/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.LimitConfig;
import dev.qixils.crowdcontrol.common.command.QuantityStyle;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.ItemCommand;
import dev.qixils.crowdcontrol.plugin.fabric.utils.InventoryUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TakeItemCommand
extends ModdedCommand
implements ItemCommand {
    @NotNull
    private final QuantityStyle quantityStyle = QuantityStyle.APPEND_X;
    private final Item item;
    private final String effectName;
    private final TranslatableComponent defaultDisplayName;

    public TakeItemCommand(ModdedCrowdControlPlugin plugin, Item item) {
        super(plugin);
        this.item = item;
        this.effectName = "take_" + BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        this.defaultDisplayName = Component.translatable((String)"cc.effect.take_item.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(item.getName(new ItemStack((ItemLike)item)))});
    }

    private boolean takeItemFrom(Player player, int amount) {
        Inventory inventory = player.getInventory();
        int toTake = 0;
        for (ItemStack itemStack : InventoryUtil.viewAllItems(inventory)) {
            if (!itemStack.isEmpty() && itemStack.getItem() == this.item && (toTake += itemStack.getCount()) >= amount) break;
        }
        if (toTake < amount) {
            return false;
        }
        toTake = amount;
        for (ItemStack itemStack : InventoryUtil.viewAllItems(inventory)) {
            if (itemStack.isEmpty() || itemStack.getItem() != this.item) continue;
            int take = Math.min(toTake, itemStack.getCount());
            itemStack.shrink(take);
            if ((toTake -= take) != 0) continue;
            break;
        }
        return true;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            LimitConfig config = this.getPlugin().getLimitConfig();
            int playerLimit = config.getItemLimit(BuiltInRegistries.ITEM.getKey((Object)this.item).getPath());
            int amount = request.getQuantity();
            return this.executeLimit(request, players, playerLimit, player -> CompletableFuture.supplyAsync(() -> {
                boolean success = false;
                try {
                    success = this.takeItemFrom((Player)player, amount);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Item could not be found in target inventories");
            }, this.getPlugin().getSyncExecutor()).join());
        }));
    }

    @Override
    @NotNull
    @Generated
    public QuantityStyle getQuantityStyle() {
        return this.quantityStyle;
    }

    @Override
    @Generated
    public Item getItem() {
        return this.item;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @Generated
    public TranslatableComponent getDefaultDisplayName() {
        return this.defaultDisplayName;
    }
}

