/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.common.util.Weighted;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.BlockFinder;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.Contract;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class VeinCommand
extends ModdedCommand {
    public static final TagKey<Block> ORES = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ores"));
    public static final TagKey<Block> ORE_BEARING_GROUND_DEEPSLATE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ore_bearing_ground/deepslate"));
    private final String effectName = "vein";

    public VeinCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Contract(mutates="param1, param2")
    private void addOreVein(List<Location> deepslateBlocks, List<Location> stoneBlocks, Location base) {
        for (int x = 0; x <= 2; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = 0; z <= 2; ++z) {
                    Location loc = base.add(x, y, z);
                    BlockState block = loc.block();
                    if (block.is(ORE_BEARING_GROUND_DEEPSLATE)) {
                        deepslateBlocks.add(loc);
                        continue;
                    }
                    if (block.isAir()) continue;
                    stoneBlocks.add(loc);
                }
            }
        }
    }

    @Contract(mutates="param1")
    private static void randomlyShrinkOreVein(List<Location> blockLocations) {
        if (blockLocations.isEmpty()) {
            return;
        }
        Collections.shuffle(blockLocations, random);
        int maxBlocks = 1 + random.nextInt(blockLocations.size());
        while (blockLocations.size() > maxBlocks) {
            blockLocations.removeFirst();
        }
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            boolean success = false;
            for (ServerPlayer player : (List)playerSupplier.get()) {
                BlockFinder finder = ((BlockFinder.BlockFinderBuilder)((BlockFinder.BlockFinderBuilder)BlockFinder.builder().origin(new Location((Entity)player)).maxRadius(6)).locationValidator(loc -> !loc.block().isAir())).build();
                Registry registry = player.level().registryAccess().lookupOrThrow(Registries.BLOCK);
                ArrayList<Ore> ores = new ArrayList<Ore>();
                ores.add(new Ore((Holder<Block>)registry.wrapAsHolder((Object)Blocks.LAVA), 1));
                ores.add(new Ore((Holder<Block>)registry.wrapAsHolder((Object)Blocks.INFESTED_STONE), (Holder<Block>)registry.wrapAsHolder((Object)Blocks.INFESTED_DEEPSLATE), 1));
                registry.getOrThrow(ORES).stream().filter(Holder::isBound).sorted((a, b) -> {
                    boolean deepslateB;
                    ResourceLocation keyA = ((ResourceKey)a.unwrapKey().get()).location();
                    ResourceLocation keyB = ((ResourceKey)b.unwrapKey().get()).location();
                    boolean deepslateA = keyA.value().startsWith("deepslate_");
                    if (deepslateA != (deepslateB = keyB.value().startsWith("deepslate_"))) {
                        return deepslateA ? 1 : -1;
                    }
                    return keyA.asString().compareTo(keyB.asString());
                }).forEachOrdered(item -> {
                    int idx;
                    Optional<Ore> matching;
                    ResourceLocation location = ((ResourceKey)item.unwrapKey().get()).location();
                    if (location.value().startsWith("deepslate_") && (matching = ores.stream().filter(ore -> {
                        ResourceLocation oreLoc = ((ResourceKey)ore.getBlock().unwrapKey().get()).location();
                        if (!location.namespace().equals(oreLoc.namespace())) {
                            return false;
                        }
                        return location.value().equals("deepslate_" + oreLoc.value());
                    }).findFirst()).isPresent() && (idx = ores.indexOf(matching.get())) != -1) {
                        ores.set(idx, matching.get().withDeepslate((Holder<Block>)item));
                        return;
                    }
                    ores.add(new Ore((Holder<Block>)item, item.is(registry.wrapAsHolder((Object)Blocks.ANCIENT_DEBRIS)) ? 3 : 6));
                });
                for (int iter = 0; iter < 3; ++iter) {
                    Ore ore = (Ore)RandomUtil.weightedRandom(ores);
                    ArrayList<Location> setBlocks = new ArrayList<Location>(8);
                    ArrayList<Location> setDeepslateBlocks = new ArrayList<Location>(8);
                    Location oreLocation = (Location)finder.next();
                    if (oreLocation == null) continue;
                    this.addOreVein(setDeepslateBlocks, setBlocks, oreLocation);
                    if (setBlocks.isEmpty() && setDeepslateBlocks.isEmpty()) continue;
                    success = true;
                    VeinCommand.randomlyShrinkOreVein(setBlocks);
                    VeinCommand.randomlyShrinkOreVein(setDeepslateBlocks);
                    this.sync(() -> {
                        setBlocks.forEach(blockPos -> blockPos.block(((Block)ore.getBlock().value()).defaultBlockState()));
                        setDeepslateBlocks.forEach(blockPos -> blockPos.block(((Block)ore.getDeepslateBlock().value()).defaultBlockState()));
                    });
                }
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not find any blocks to replace");
        }));
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    public static class Ore
    implements Weighted {
        private final Holder<Block> block;
        private final Holder<Block> deepslateBlock;
        private final int weight;

        Ore(Holder<Block> block, Holder<Block> deepslateBlock, int weight) {
            this.block = block;
            this.deepslateBlock = deepslateBlock;
            this.weight = weight;
        }

        Ore(Holder<Block> block, int weight) {
            this(block, block, weight);
        }

        public Ore withDeepslate(Holder<Block> deepslateBlock) {
            return new Ore(this.block, deepslateBlock, this.weight);
        }

        @Generated
        public Holder<Block> getBlock() {
            return this.block;
        }

        @Generated
        public Holder<Block> getDeepslateBlock() {
            return this.deepslateBlock;
        }

        @Override
        @Generated
        public int getWeight() {
            return this.weight;
        }
    }
}

