/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands.executeorperish;

import dev.qixils.crowdcontrol.common.EventListener;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.CCResponseException;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.common.util.sound.Sounds;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.GiveItemCommand;
import dev.qixils.crowdcontrol.plugin.fabric.commands.LootboxCommand;
import dev.qixils.crowdcontrol.plugin.fabric.commands.executeorperish.Condition;
import dev.qixils.crowdcontrol.plugin.fabric.commands.executeorperish.SuccessCondition;
import dev.qixils.crowdcontrol.plugin.fabric.event.Listener;
import dev.qixils.crowdcontrol.plugin.fabric.event.Tick;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.title.Title;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

@EventListener
public class DoOrDieCommand
extends ModdedCommand {
    private final String effectName = "do_or_die";
    private final List<Task> tasks = new ArrayList<Task>();

    public DoOrDieCommand(@NotNull ModdedCrowdControlPlugin plugin) {
        super(plugin);
        for (SuccessCondition condition : Condition.items()) {
            if (!condition.getClass().isAnnotationPresent(EventListener.class)) continue;
            plugin.getEventManager().registerListeners(condition);
        }
    }

    @Listener
    public void onTick(Tick tick) {
        Iterator<Task> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            Task task = iterator.next();
            if (task.ticksElapsed(tick) % 2 != 0 || !task.run(tick)) continue;
            iterator.remove();
        }
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            ArrayList<SuccessCondition> conditions = new ArrayList<SuccessCondition>(Condition.items());
            Collections.shuffle(conditions, random);
            SuccessCondition condition = conditions.stream().filter(cond -> cond.canApply(players)).findAny().orElseThrow(() -> new CCResponseException(new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not find a challenge to apply")));
            players.forEach(condition::track);
            Task task = new Task(this.plugin, this.plugin.server().getTickCount(), players.stream().map(Entity::getUUID).collect(Collectors.toSet()), condition, condition.getComponent());
            if (!task.run(null)) {
                task.register();
            }
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Generated
    public List<Task> getTasks() {
        return this.tasks;
    }

    private final class Task {
        private final ModdedCrowdControlPlugin plugin;
        private final int startedAt;
        private final Set<UUID> notCompleted;
        private final SuccessCondition condition;
        private final Component subtitle;
        private int pastValue = 0;

        public int ticksElapsed(@Nullable Tick event) {
            int tick = event == null ? this.plugin.server().getTickCount() : event.tickCount();
            return Math.max(tick - this.startedAt, 1);
        }

        public boolean run(@Nullable Tick event) {
            int ticksElapsed = this.ticksElapsed(event);
            int secondsLeft = (int)CommandConstants.DO_OR_DIE_DURATION.getSeconds() - (int)Math.ceil((float)ticksElapsed / 20.0f);
            boolean isNewValue = secondsLeft != this.pastValue;
            this.pastValue = secondsLeft;
            boolean isTimeUp = secondsLeft <= 0;
            for (UUID uuid : this.notCompleted) {
                ServerPlayer player = this.plugin.server().getPlayerList().getPlayer(uuid);
                if (player == null) continue;
                if (this.condition.hasSucceeded(player)) {
                    ItemStack reward = this.plugin.commandRegister().getCommandByName("lootbox", LootboxCommand.class).createRandomItem(this.condition.getRewardLuck(), player.registryAccess());
                    player.showTitle(CommandConstants.doOrDieSuccess((ComponentLike)this.plugin.toAdventure(reward.getItem().getName(reward))));
                    this.notCompleted.remove(uuid);
                    player.playSound(Sounds.DO_OR_DIE_SUCCESS_CHIME.get(new Object[0]), Sound.Emitter.self());
                    DoOrDieCommand.this.sync(() -> GiveItemCommand.giveItemTo(player, reward));
                    continue;
                }
                if (isTimeUp) {
                    this.condition.reset(player);
                    player.showTitle(CommandConstants.DO_OR_DIE_FAILURE);
                    player.kill(player.level());
                    continue;
                }
                Component main = Component.text((int)secondsLeft).color(CommandConstants.doOrDieColor(secondsLeft));
                player.showTitle(Title.title((Component)main, (Component)this.subtitle, (Title.Times)CommandConstants.DO_OR_DIE_TIMES));
                if (!isNewValue) continue;
                player.playSound(Sounds.DO_OR_DIE_TICK.get(new Object[0]), Sound.Emitter.self());
            }
            return isTimeUp;
        }

        public void register() {
            DoOrDieCommand.this.tasks.add(this);
        }

        @Generated
        public Task(ModdedCrowdControlPlugin plugin, int startedAt, Set<UUID> notCompleted, SuccessCondition condition, Component subtitle) {
            this.plugin = plugin;
            this.startedAt = startedAt;
            this.notCompleted = notCompleted;
            this.condition = condition;
            this.subtitle = subtitle;
        }

        @Generated
        public ModdedCrowdControlPlugin getPlugin() {
            return this.plugin;
        }

        @Generated
        public int getStartedAt() {
            return this.startedAt;
        }

        @Generated
        public Set<UUID> getNotCompleted() {
            return this.notCompleted;
        }

        @Generated
        public SuccessCondition getCondition() {
            return this.condition;
        }

        @Generated
        public Component getSubtitle() {
            return this.subtitle;
        }

        @Generated
        public int getPastValue() {
            return this.pastValue;
        }

        @Generated
        public void setPastValue(int pastValue) {
            this.pastValue = pastValue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Task)) {
                return false;
            }
            Task other = (Task)o;
            if (this.getStartedAt() != other.getStartedAt()) {
                return false;
            }
            if (this.getPastValue() != other.getPastValue()) {
                return false;
            }
            ModdedCrowdControlPlugin this$plugin = this.getPlugin();
            ModdedCrowdControlPlugin other$plugin = other.getPlugin();
            if (this$plugin == null ? other$plugin != null : !this$plugin.equals(other$plugin)) {
                return false;
            }
            Set<UUID> this$notCompleted = this.getNotCompleted();
            Set<UUID> other$notCompleted = other.getNotCompleted();
            if (this$notCompleted == null ? other$notCompleted != null : !((Object)this$notCompleted).equals(other$notCompleted)) {
                return false;
            }
            SuccessCondition this$condition = this.getCondition();
            SuccessCondition other$condition = other.getCondition();
            if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
                return false;
            }
            Component this$subtitle = this.getSubtitle();
            Component other$subtitle = other.getSubtitle();
            return !(this$subtitle == null ? other$subtitle != null : !this$subtitle.equals(other$subtitle));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStartedAt();
            result = result * 59 + this.getPastValue();
            ModdedCrowdControlPlugin $plugin = this.getPlugin();
            result = result * 59 + ($plugin == null ? 43 : $plugin.hashCode());
            Set<UUID> $notCompleted = this.getNotCompleted();
            result = result * 59 + ($notCompleted == null ? 43 : ((Object)$notCompleted).hashCode());
            SuccessCondition $condition = this.getCondition();
            result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
            Component $subtitle = this.getSubtitle();
            result = result * 59 + ($subtitle == null ? 43 : $subtitle.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DoOrDieCommand.Task(plugin=" + String.valueOf(this.getPlugin()) + ", startedAt=" + this.getStartedAt() + ", notCompleted=" + String.valueOf(this.getNotCompleted()) + ", condition=" + String.valueOf(this.getCondition()) + ", subtitle=" + String.valueOf(this.getSubtitle()) + ", pastValue=" + this.getPastValue() + ")";
        }
    }
}

