/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.neoforge;

import dev.qixils.crowdcontrol.common.VersionMetadata;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.packets.neoforge.PacketUtilImpl;
import dev.qixils.crowdcontrol.plugin.fabric.utils.PermissionUtil;
import dev.qixils.crowdcontrol.plugin.neoforge.NeoForgeInitializer;
import dev.qixils.crowdcontrol.plugin.neoforge.util.LuckPermsPermissionUtil;
import dev.qixils.crowdcontrol.plugin.neoforge.util.NeoForgePermissionUtil;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import lombok.Generated;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.neoforge.NeoForgeServerCommandManager;

public class NeoForgeCrowdControlPlugin
extends ModdedCrowdControlPlugin {
    private final NeoForgeServerCommandManager<CommandSourceStack> commandManager = NeoForgeServerCommandManager.createNative((ExecutionCoordinator)ExecutionCoordinator.asyncCoordinator());
    private final PermissionUtil permissionUtil;
    private final ModContainer container;

    public NeoForgeCrowdControlPlugin(ModContainer container, IEventBus modBus) {
        this.container = container;
        this.permissionUtil = ModList.get().isLoaded("luckperms") ? new LuckPermsPermissionUtil() : new NeoForgePermissionUtil();
        this.onInitialize();
        modBus.addListener(this::register);
    }

    public void register(RegisterPayloadHandlersEvent event) {
        PacketUtilImpl.registerPackets(event);
    }

    @Override
    @Nullable
    public Path getPath(@NotNull String asset) {
        return NeoForgeInitializer.container.getModInfo().getOwningFile().getFile().findResource(new String[]{asset});
    }

    @Override
    public InputStream getInputStream(@NotNull String asset) {
        Path path = this.getPath(asset);
        if (path == null) {
            return null;
        }
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            this.getSLF4JLogger().warn("Encountered exception while retrieving asset {}", (Object)asset, (Object)e);
            return null;
        }
    }

    @Override
    @NotNull
    public VersionMetadata getVersionMetadata() {
        return new VersionMetadata(this.server().getServerVersion(), "NeoForge", this.server().getServerModName(), FMLLoader.versionInfo().neoForgeVersion());
    }

    @Override
    public void sendToPlayer(@NotNull ServerPlayer player, @NotNull CustomPacketPayload payload) {
        try {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        catch (UnsupportedOperationException e) {
            this.getSLF4JLogger().debug("Player {} cannot receive packet {}", (Object)player, (Object)payload);
        }
    }

    @Override
    @Generated
    public NeoForgeServerCommandManager<CommandSourceStack> getCommandManager() {
        return this.commandManager;
    }

    @Override
    @Generated
    public PermissionUtil getPermissionUtil() {
        return this.permissionUtil;
    }

    @Generated
    public ModContainer getContainer() {
        return this.container;
    }
}

