/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.adventure.minimessage.tag.standard;

import dev.qixils.relocated.adventure.minimessage.Context;
import dev.qixils.relocated.adventure.minimessage.ParsingException;
import dev.qixils.relocated.adventure.minimessage.internal.serializer.SerializableResolver;
import dev.qixils.relocated.adventure.minimessage.internal.serializer.StyleClaim;
import dev.qixils.relocated.adventure.minimessage.internal.serializer.TokenEmitter;
import dev.qixils.relocated.adventure.minimessage.tag.Tag;
import dev.qixils.relocated.adventure.minimessage.tag.resolver.ArgumentQueue;
import dev.qixils.relocated.adventure.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.key.InvalidKeyException;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.format.Style;

final class FontTag {
    static final String FONT = "font";
    static final TagResolver RESOLVER = SerializableResolver.claimingStyle("font", FontTag::create, StyleClaim.claim("font", Style::font, FontTag::emit));

    private FontTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        Key font;
        String valueOrNamespace = args.popOr("A font tag must have either arguments of either <value> or <namespace:value>").value();
        try {
            if (!args.hasNext()) {
                font = Key.key((String)valueOrNamespace);
            } else {
                String fontKey = args.pop().value();
                font = Key.key((String)valueOrNamespace, (String)fontKey);
            }
        }
        catch (InvalidKeyException ex) {
            throw ctx.newException(ex.getMessage(), args);
        }
        return Tag.styling(builder -> builder.font(font));
    }

    static void emit(Key font, TokenEmitter emitter) {
        emitter.tag(FONT);
        if (font.namespace().equals("minecraft")) {
            emitter.argument(font.value());
        } else {
            emitter.arguments(font.namespace(), font.value());
        }
    }
}

