/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.command;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.util.KeyedTag;
import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.common.util.Weighted;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.translation.Translatable;
import net.kyori.adventure.util.RGBLike;

public class CommandConstants {
    public static final UUID GRAVITY_MODIFIER_UUID = new UUID(723038618076398311L, -6545840742910585990L);
    public static final UUID FALL_MODIFIER_UUID = new UUID(7266512121322359285L, -8208555834343603830L);
    public static final UUID FALL_DMG_MODIFIER_UUID = new UUID(-2464474606488170752L, 8005989740147089956L);
    public static final UUID SCALE_MODIFIER_UUID = new UUID(-2378341764646484063L, -8318356916108535959L);
    public static final UUID SCALE_STEP_MODIFIER_UUID = new UUID(8279684539680771938L, -4906911542497939969L);
    public static final UUID SCALE_JUMP_MODIFIER_UUID = new UUID(7320315186307875087L, -5912984502438606275L);
    public static final UUID ANT_SCALE_MODIFIER_UUID = new UUID(-1821843958642947773L, -5045337188442667310L);
    public static final String ANT_SCALE_MODIFIER_NAME = "ant-scale-cc";
    public static final UUID ANT_SPEED_MODIFIER_UUID = new UUID(5811146150910903844L, -5416149565125762405L);
    public static final String ANT_SPEED_MODIFIER_NAME = "ant-speed-cc";
    public static final UUID ANT_STEP_MODIFIER_UUID = new UUID(1326713636513333747L, -6767548671610976425L);
    public static final String ANT_STEP_MODIFIER_NAME = "ant-step-cc";
    public static final UUID ANT_RANGE_MODIFIER_UUID = new UUID(2422796905512585387L, -8469336011429629212L);
    public static final String ANT_RANGE_MODIFIER_NAME = "ant-range-cc";
    public static final String GRAVITY_MODIFIER_NAME = "gravity-cc";
    public static final String FALL_MODIFIER_NAME = "fall-cc";
    public static final String FALL_DMG_MODIFIER_NAME = "fall-dmg-cc";
    public static final String SCALE_MODIFIER_NAME = "scale-cc";
    public static final String SCALE_STEP_MODIFIER_NAME = "scale-step-cc";
    public static final String SCALE_JUMP_MODIFIER_NAME = "scale-jump-cc";
    @Nullable
    public static Predicate<Key> SOUND_VALIDATOR = null;
    public static final int REMOVE_ENTITY_RADIUS = 35;
    @NotNull
    public static final String DINNERBONE_NAME = "Dinnerbone";
    @NotNull
    public static final Component DINNERBONE_COMPONENT = Component.text((String)"Dinnerbone");
    public static final int ENTITY_SEARCH_RADIUS = 30;
    public static final int FALLING_BLOCK_FALL_DISTANCE = 5;
    public static final long WEATHER_TICKS = 72000L;
    @NotNull
    public static final Duration DISABLE_JUMPING_DURATION = Duration.ofSeconds(10L);
    @NotNull
    public static final Duration INVERT_CONTROLS_DURATION = Duration.ofSeconds(15L);
    public static final int FLOWER_RADIUS = 10;
    public static final int FLOWER_MIN = 14;
    public static final int FLOWER_MAX = 28;
    public static final double DIG_RADIUS = 0.5;
    @NotNull
    public static final Component KEEP_INVENTORY_MESSAGE = Component.translatable((String)"cc.effect.keep_inventory_on.output", (TextColor)NamedTextColor.GREEN);
    @NotNull
    public static final Component LOSE_INVENTORY_MESSAGE = Component.translatable((String)"cc.effect.keep_inventory_off.output", (TextColor)NamedTextColor.RED);
    public static final int MIN_MAX_HEALTH = 10;
    public static final int CLUTTER_ITEMS = 6;
    public static final int VEIN_RADIUS = 6;
    public static final int VEIN_COUNT = 3;
    @NotNull
    public static final KeyedTag SET_BLOCKS = new KeyedTag(Key.key((String)"minecraft", (String)"tnt"), Key.key((String)"minecraft", (String)"fire"), Key.key((String)"minecraft", (String)"cobweb"), Key.key((String)"minecraft", (String)"redstone_torch"), Key.key((String)"minecraft", (String)"wither_rose"), Key.key((String)"minecraft", (String)"lightning_rod"), Key.key((String)"minecraft", (String)"bedrock"), Key.key((String)"minecraft", (String)"water"), Key.key((String)"minecraft", (String)"sculk_catalyst"));
    @NotNull
    public static final KeyedTag SET_FALLING_BLOCKS = new KeyedTag(Key.key((String)"minecraft", (String)"anvil"), Key.key((String)"minecraft", (String)"sand"), Key.key((String)"minecraft", (String)"red_sand"), Key.key((String)"minecraft", (String)"gravel"));
    public static final int ENTITY_ARMOR_START = 4;
    public static final int ENTITY_ARMOR_INC = 2;
    public static final int POTION_SECONDS = 20;
    public static final long DAY = 1000L;
    public static final long NIGHT = 13000L;
    private static final int MIN_ITEM_DAMAGE_VALUE = 15;
    public static final int ITEM_DAMAGE_PERCENTAGE = 4;
    public static final int MIN_ITEM_DAMAGE_PERCENTAGE = 5;
    public static final int CHAOS_LOCAL_RADIUS = 20;
    public static final int BUCKET_CLUTCH_MIN = 30;
    public static final int BUCKET_CLUTCH_MAX = 100;
    public static final double UNBREAKABLE_BASE = 0.95;
    public static final double UNBREAKABLE_DEC = 0.1;
    public static final int ARMOR_TRIM_ODDS = 4;
    public static final Component POPUP_TITLE = Component.translatable((String)"cc.effect.toast.title");
    @NotNull
    public static final KeyedTag GIVE_TAKE_ITEMS = new KeyedTag(Key.key((String)"minecraft", (String)"wooden_pickaxe"), Key.key((String)"minecraft", (String)"stone_pickaxe"), Key.key((String)"minecraft", (String)"golden_pickaxe"), Key.key((String)"minecraft", (String)"iron_pickaxe"), Key.key((String)"minecraft", (String)"diamond_pickaxe"), Key.key((String)"minecraft", (String)"netherite_pickaxe"), Key.key((String)"minecraft", (String)"golden_apple"), Key.key((String)"minecraft", (String)"enchanted_golden_apple"), Key.key((String)"minecraft", (String)"ender_eye"), Key.key((String)"minecraft", (String)"end_portal_frame"), Key.key((String)"minecraft", (String)"elytra"), Key.key((String)"minecraft", (String)"trident"), Key.key((String)"minecraft", (String)"coal"), Key.key((String)"minecraft", (String)"iron_ingot"), Key.key((String)"minecraft", (String)"gold_ingot"), Key.key((String)"minecraft", (String)"diamond"), Key.key((String)"minecraft", (String)"netherite_ingot"), Key.key((String)"minecraft", (String)"wooden_sword"), Key.key((String)"minecraft", (String)"stone_sword"), Key.key((String)"minecraft", (String)"golden_sword"), Key.key((String)"minecraft", (String)"iron_sword"), Key.key((String)"minecraft", (String)"diamond_sword"), Key.key((String)"minecraft", (String)"netherite_sword"), Key.key((String)"minecraft", (String)"cooked_porkchop"), Key.key((String)"minecraft", (String)"recovery_compass"), Key.key((String)"minecraft", (String)"stick"), Key.key((String)"minecraft", (String)"mace"));
    @NotNull
    public static final KeyedTag FLOWERS = new KeyedTag(Key.key((String)"minecraft", (String)"poppy"), Key.key((String)"minecraft", (String)"dandelion"), Key.key((String)"minecraft", (String)"blue_orchid"), Key.key((String)"minecraft", (String)"allium"), Key.key((String)"minecraft", (String)"azure_bluet"), Key.key((String)"minecraft", (String)"orange_tulip"), Key.key((String)"minecraft", (String)"red_tulip"), Key.key((String)"minecraft", (String)"pink_tulip"), Key.key((String)"minecraft", (String)"white_tulip"), Key.key((String)"minecraft", (String)"oxeye_daisy"), Key.key((String)"minecraft", (String)"cornflower"), Key.key((String)"minecraft", (String)"lily_of_the_valley"), Key.key((String)"minecraft", (String)"wither_rose"), Key.key((String)"minecraft", (String)"brown_mushroom"), Key.key((String)"minecraft", (String)"red_mushroom"), Key.key((String)"minecraft", (String)"crimson_fungus"), Key.key((String)"minecraft", (String)"warped_fungus"), Key.key((String)"minecraft", (String)"red_flower"), Key.key((String)"minecraft", (String)"yellow_flower"));
    @NotNull
    public static final KeyedTag TORCHES = new KeyedTag(Key.key((String)"minecraft", (String)"torch"), Key.key((String)"minecraft", (String)"redstone_torch"), Key.key((String)"minecraft", (String)"soul_torch"), Key.key((String)"minecraft", (String)"wall_torch"), Key.key((String)"minecraft", (String)"redstone_wall_torch"), Key.key((String)"minecraft", (String)"soul_wall_torch"));
    @NotNull
    public static final Set<String> BLACKLISTED_ENTITIES = Set.of("marker", "");
    @NotNull
    public static final Set<String> ENTITIES = new HashSet<String>(Arrays.asList("allay", "armadillo", "armor_stand", "axolotl", "bat", "bee", "blaze", "bogged", "breeze", "boat", "chest_boat", "camel", "cat", "cave_spider", "charged_creeper", "chicken", "cod", "cow", "creaking", "creeper", "dolphin", "donkey", "drowned", "elder_guardian", "ender_dragon", "enderman", "endermite", "evoker", "fox", "frog", "ghast", "giant", "glow_squid", "goat", "guardian", "hoglin", "horse", "husk", "illusioner", "iron_golem", "lightning", "llama", "magma_cube", "minecart", "minecart_chest", "mushroom_cow", "mule", "ocelot", "panda", "parrot", "phantom", "pig", "piglin", "piglin_brute", "pillager", "polar_bear", "primed_tnt", "pufferfish", "rabbit", "ravager", "salmon", "sheep", "shulker", "silverfish", "skeleton", "skeleton_horse", "slime", "sniffer", "snowman", "spider", "squid", "stray", "strider", "tadpole", "trader_llama", "tropical_fish", "turtle", "vex", "villager", "vindicator", "wandering_trader", "warden", "witch", "wither", "wither_skeleton", "wolf", "zoglin", "zombie", "zombie_horse", "zombie_villager", "zombified_piglin"));
    @NotNull
    public static final Duration DO_OR_DIE_DURATION = Duration.ofSeconds(31L);
    @NotNull
    public static final Duration DO_OR_DIE_COOLDOWN = DO_OR_DIE_DURATION.plusSeconds(5L);
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Title.Times DO_OR_DIE_TIMES = Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(4L), (Duration)Duration.ofSeconds(1L));
    @NotNull
    public static final Title DO_OR_DIE_FAILURE = Title.title((Component)Component.translatable((String)"cc.effect.do_or_die.failure", (TextColor)NamedTextColor.RED), (Component)Component.empty(), (Title.Times)DO_OR_DIE_TIMES);
    @NotNull
    private static final TextColor DO_OR_DIE_START_COLOR = TextColor.color((int)15005501);
    @NotNull
    private static final TextColor DO_OR_DIE_END_COLOR = TextColor.color((int)16001321);
    @NotNull
    private static final TextColor SUCCESS_SUBTITLE_COLOR = TextColor.color((int)0x99FF99);
    public static final double HALVE_HEALTH_MIN_HEALTH = 6.0;
    public static final int BIOME_SEARCH_RADIUS = 512;
    public static final int BIOME_SEARCH_STEP = 32;
    public static final int STRUCTURE_SEARCH_RADIUS = 64;
    public static final boolean STRUCTURE_SEARCH_UNEXPLORED = false;
    public static final double MUSHROOM_COW_BROWN_CHANCE = 0.01;
    public static final int EAT_CHORUS_FRUIT_MIN_RADIUS = 3;
    public static final int EAT_CHORUS_FRUIT_MAX_RADIUS = 16;
    public static final int ENTITY_CHAOS_MIN = 10;

    public static String asMinimalString(Key key) {
        return key.asMinimalString();
    }

    public static String asMinimalSafeString(Key key) {
        return key.namespace().equals("minecraft") ? key.value() : key.namespace() + "_" + key.value();
    }

    public static boolean isWhitelistedEntity(Keyed keyed) {
        Key key = keyed.key();
        return ENTITIES.contains(CommandConstants.asMinimalString(key)) || ENTITIES.contains(CommandConstants.csIdOf((Keyed)key));
    }

    private CommandConstants() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    @NotNull
    public static Title doOrDieSuccess(@NotNull Translatable rewardItem) {
        return CommandConstants.doOrDieSuccess((ComponentLike)Component.translatable((Translatable)rewardItem));
    }

    @NotNull
    public static Title doOrDieSuccess(@NotNull ComponentLike rewardItem) {
        return Title.title((Component)Component.translatable((String)"cc.effect.do_or_die.title").color((TextColor)NamedTextColor.GREEN), (Component)Component.translatable((String)"cc.effect.do_or_die.subtitle", (TextColor)SUCCESS_SUBTITLE_COLOR, (ComponentLike[])new ComponentLike[]{rewardItem}), (Title.Times)DO_OR_DIE_TIMES);
    }

    public static TextColor doOrDieColor(int secondsLeft) {
        return TextColor.lerp((float)(((float)secondsLeft - 1.0f) / (float)DO_OR_DIE_DURATION.getSeconds()), (RGBLike)DO_OR_DIE_END_COLOR, (RGBLike)DO_OR_DIE_START_COLOR);
    }

    public static boolean canApplyDurability(int oldDurability, int newDurability, int maxDurability) {
        if (oldDurability == newDurability) {
            return false;
        }
        if (maxDurability == newDurability) {
            return true;
        }
        int min = Math.max(15, maxDurability / 5);
        return newDurability >= min;
    }

    public static boolean canApplyDamage(int oldDamage, int newDamage, int maxDurability) {
        return CommandConstants.canApplyDurability(maxDurability - oldDamage, maxDurability - newDamage, maxDurability);
    }

    public static Component buildLootboxTitle(@NotNull Plugin<?, ?> plugin, @NotNull PublicEffectPayload request) {
        return Component.translatable((String)"cc.effect.lootbox.title", (ComponentLike[])new ComponentLike[]{plugin.getViewerComponent(request, false).color(Plugin.USER_COLOR)});
    }

    public static Component buildLootboxLore(@NotNull Plugin<?, ?> plugin, @NotNull PublicEffectPayload request) {
        return Component.translatable((String)"cc.effect.lootbox.lore", (ComponentLike[])new ComponentLike[]{plugin.getViewerComponent(request, false).color(Plugin.USER_COLOR).decorate(TextDecoration.ITALIC)});
    }

    public static int getDigDepth() {
        return -(3 + RandomUtil.RNG.nextInt(5));
    }

    public static double explosionPower() {
        return Math.max((double)Math.round(RandomUtil.RNG.doubles(4L, 1.0, 7.0).average().orElse(5.0)), 2.5);
    }

    public static boolean shouldSpawnFire() {
        return RandomUtil.RNG.nextDouble() >= 0.95;
    }

    @NotNull
    public static @NotNull Collection<@NotNull Integer> lootboxItemSlots(int luck) {
        if (luck >= 10) {
            return Arrays.asList(11, 13, 15);
        }
        if (luck >= 5) {
            return Arrays.asList(12, 14);
        }
        return Collections.singletonList(13);
    }

    private static double randomFlingHoriz() {
        return (double)(RandomUtil.RNG.nextBoolean() ? -1 : 1) * RandomUtil.RNG.nextDouble(1.2, 3.0);
    }

    public static double @NotNull [] randomFlingVector() {
        return new double[]{CommandConstants.randomFlingHoriz(), RandomUtil.RNG.nextDouble(0.4, 1.5), CommandConstants.randomFlingHoriz()};
    }

    @NotNull
    public static String csIdOf(Keyed _id) {
        String path;
        Key id = _id.key();
        if (!id.namespace().equals("minecraft")) {
            return CommandConstants.asMinimalSafeString(id);
        }
        switch (path = id.value()) {
            case "lightning_bolt": {
                return "lightning";
            }
            case "chest_minecart": {
                return "minecart_chest";
            }
            case "mooshroom": {
                return "mushroom_cow";
            }
            case "tnt": {
                return "primed_tnt";
            }
            case "snow_golem": {
                return "snowman";
            }
            case "binding_curse": {
                return "curse_of_binding";
            }
            case "vanishing_curse": {
                return "curse_of_vanishing";
            }
            case "sweeping": {
                return "sweeping_edge";
            }
            case "villager_golem": {
                return "iron_golem";
            }
            case "zombie_pigman": {
                return "zombified_piglin";
            }
            case "illusion_illager": {
                return "illusioner";
            }
            case "vindication_illager": {
                return "vindicator";
            }
            case "furnace_minecart": {
                return "minecart_furnace";
            }
            case "hopper_minecart": {
                return "minecart_hopper";
            }
            case "tnt_minecart": {
                return "minecart_tnt";
            }
        }
        return path;
    }

    public static enum EnchantmentWeights implements Weighted
    {
        ONE(1, 40),
        TWO(2, 15),
        THREE(3, 3),
        FOUR(4, 2),
        FIVE(5, 1);

        public static final int TOTAL_WEIGHTS;
        private final int level;
        private final int weight;

        private EnchantmentWeights(int level, int weight) {
            this.level = level;
            this.weight = weight;
        }

        @Generated
        public int getLevel() {
            return this.level;
        }

        @Override
        @Generated
        public int getWeight() {
            return this.weight;
        }

        static {
            TOTAL_WEIGHTS = Arrays.stream(EnchantmentWeights.values()).mapToInt(EnchantmentWeights::getWeight).sum();
        }
    }

    public static enum AttributeWeights implements Weighted
    {
        NONE(0, 167),
        ONE(1, 20),
        TWO(2, 10),
        THREE(3, 4),
        FOUR(4, 2),
        FIVE(5, 1);

        public static final int TOTAL_WEIGHTS;
        private final int level;
        private final int weight;

        private AttributeWeights(int level, int weight) {
            this.level = level;
            this.weight = weight;
        }

        @Generated
        public int getLevel() {
            return this.level;
        }

        @Override
        @Generated
        public int getWeight() {
            return this.weight;
        }

        static {
            TOTAL_WEIGHTS = Arrays.stream(AttributeWeights.values()).mapToInt(AttributeWeights::getWeight).sum();
        }
    }
}

