/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.util.sound;

import dev.qixils.crowdcontrol.common.util.sound.DynamicSound;
import dev.qixils.crowdcontrol.common.util.sound.FallbackSound;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LootboxSound
implements DynamicSound {
    private static final Logger logger = LoggerFactory.getLogger((String)"CrowdControl/LootboxSound");
    private static final Sound.Source SOURCE = Sound.Source.PLAYER;
    private static final DynamicSound STANDARD = new FallbackSound(SOURCE, 1.0f, 1.2f, Key.key((String)"minecraft", (String)"block.note_block.chime"), Key.key((String)"minecraft", (String)"block.note.chime"));
    private static final DynamicSound LUCKY = new FallbackSound(SOURCE, 1.0f, 1.4f, Key.key((String)"minecraft", (String)"block.note_block.chime"), Key.key((String)"minecraft", (String)"block.note.chime"));
    private static final DynamicSound EXTRA_LUCKY = new FallbackSound(SOURCE, 0.3f, 1.0f, Key.key((String)"minecraft", (String)"ui.toast.challenge_complete"));

    LootboxSound() {
    }

    @Override
    @NotNull
    public Optional<Sound> get(@Nullable Predicate<@NotNull Key> validator, Object ... args) {
        int luck;
        if (args == null || args.length == 0) {
            luck = 0;
        } else if (args[0] instanceof Integer) {
            luck = (Integer)args[0];
        } else {
            logger.warn("An invalid argument array was passed: " + Arrays.toString(args));
            luck = 0;
        }
        if (luck >= 10) {
            return EXTRA_LUCKY.get(validator, new Object[0]);
        }
        if (luck >= 5) {
            return LUCKY.get(validator, new Object[0]);
        }
        return STANDARD.get(validator, new Object[0]);
    }
}

