/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.FeatureElementCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.BlockFinder;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockCommand
extends ModdedCommand
implements FeatureElementCommand {
    private final Block blockType;
    private final String effectName;
    private final net.kyori.adventure.text.Component displayName;

    public BlockCommand(ModdedCrowdControlPlugin plugin, Block blockType) {
        this(plugin, blockType, "block_" + BuiltInRegistries.BLOCK.getKey((Object)blockType).getPath(), (net.kyori.adventure.text.Component)net.kyori.adventure.text.Component.translatable((String)"cc.effect.block.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure((Component)blockType.getName())}));
    }

    protected BlockCommand(ModdedCrowdControlPlugin plugin, Block blockType, String effectName, net.kyori.adventure.text.Component displayName) {
        super(plugin);
        this.blockType = blockType;
        this.effectName = effectName;
        this.displayName = displayName;
    }

    @NotNull
    public FeatureFlagSet requiredFeatures() {
        return this.blockType.requiredFeatures();
    }

    @Nullable
    protected Location getLocation(ServerPlayer player) {
        Location location = new Location((Entity)player);
        if (!BlockFinder.isReplaceable(location)) {
            return null;
        }
        return location;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            boolean success = false;
            for (ServerPlayer player : (List)playerSupplier.get()) {
                Location location = this.getLocation(player);
                if (location == null) continue;
                BlockState currentBlock = location.block();
                Block currentType = currentBlock.getBlock();
                if (!BlockFinder.isReplaceable(currentBlock) || currentType.equals(this.blockType)) continue;
                success = true;
                this.sync(() -> location.block(this.blockType.defaultBlockState()));
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No available locations to set blocks");
        }));
    }

    @Generated
    public Block getBlockType() {
        return this.blockType;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @Generated
    public net.kyori.adventure.text.Component getDisplayName() {
        return this.displayName;
    }
}

