/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.BlockFinder;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;

public class BucketClutchCommand
extends ModdedCommand {
    private final String effectName = "bucket_clutch";

    public BucketClutchCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            boolean success = false;
            for (ServerPlayer player : (List)playerSupplier.get()) {
                Item material = player.level().dimensionType().ultraWarm() ? Items.COBWEB : Items.WATER_BUCKET;
                ItemStack giveItem = new ItemStack((ItemLike)material);
                player.registryAccess().lookup(Registries.ENCHANTMENT).flatMap(registry -> registry.get(Enchantments.VANISHING_CURSE)).ifPresent(enchantment -> giveItem.enchant((Holder)enchantment, 1));
                Location curr = new Location((Entity)player);
                int offset = 99;
                for (int y = 1; y <= 100; ++y) {
                    if (BlockFinder.isPassable(curr.add(0.0, y, 0.0))) continue;
                    offset = y - 2;
                    break;
                }
                if (offset < 30) continue;
                Location dest = curr.add(0.0, offset, 0.0);
                success = true;
                this.sync(() -> {
                    player.teleportTo(dest.x(), dest.y(), dest.z());
                    ItemStack hand = player.getMainHandItem();
                    if (!hand.isEmpty() && hand.getItem() != material) {
                        ItemStack offhand = player.getOffhandItem();
                        if (offhand.isEmpty()) {
                            player.setItemInHand(InteractionHand.OFF_HAND, hand);
                        } else {
                            boolean slotFound = false;
                            Inventory inv = player.getInventory();
                            for (int i = 0; i < 36; ++i) {
                                ItemStack item = inv.getItem(i);
                                if (!item.isEmpty()) continue;
                                slotFound = true;
                                inv.setItem(i, hand);
                                break;
                            }
                            if (!slotFound) {
                                player.drop(true);
                            }
                        }
                    }
                    player.setItemInHand(InteractionHand.MAIN_HAND, giveItem.copy());
                });
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No players are on the surface");
        }));
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }
}

