/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.common.Global;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;

@Global
public class DifficultyCommand
extends ModdedCommand {
    private final Difficulty difficulty;
    private final String effectName;
    private final Component displayName;

    private static String effectNameOf(Difficulty difficulty) {
        return "difficulty_" + difficulty.getKey();
    }

    public DifficultyCommand(ModdedCrowdControlPlugin plugin, Difficulty difficulty) {
        super(plugin);
        this.difficulty = difficulty;
        this.effectName = DifficultyCommand.effectNameOf(difficulty);
        this.displayName = Component.translatable((String)"cc.effect.difficulty.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(difficulty.getDisplayName())});
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            playerSupplier.get();
            if (this.plugin.server().getWorldData().isDifficultyLocked()) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_PERMANENT, "Server difficulty is locked");
            }
            if (this.plugin.server().getWorldData().getDifficulty() == this.difficulty) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Server difficulty is already set to " + String.valueOf(this.displayName));
            }
            this.async(this.plugin::updateConditionalEffectVisibility);
            this.sync(() -> this.plugin.server().setDifficulty(this.difficulty, true));
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }));
    }

    @Override
    public TriState isVisible(@NotNull IUserRecord user, @NotNull List<ServerPlayer> potentialPlayers) {
        if (this.plugin.server().getWorldData().isDifficultyLocked()) {
            return TriState.FALSE;
        }
        return TriState.TRUE;
    }

    @Override
    public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<ServerPlayer> potentialPlayers) {
        if (this.plugin.server().getWorldData().getDifficulty() == this.difficulty) {
            return TriState.FALSE;
        }
        return TriState.TRUE;
    }

    @Generated
    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @Generated
    public Component getDisplayName() {
        return this.displayName;
    }
}

