/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.AttributeUtil;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class EntitySizeCommand
extends ModdedCommand {
    private final Duration defaultDuration = Duration.ofSeconds(30L);
    private final String effectName;
    private final double level;
    private static final double radius = Math.pow(30.0, 2.0);

    public EntitySizeCommand(ModdedCrowdControlPlugin plugin, String effectName, double level) {
        super(plugin);
        this.effectName = effectName;
        this.level = level;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            MinecraftServer server = this.plugin.getServer();
            if (server == null) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Server not active");
            }
            Set locations = ((List)playerSupplier.get()).stream().map(Location::new).collect(Collectors.toSet());
            boolean success = false;
            for (ServerLevel world : this.plugin.getServer().getAllLevels()) {
                block1: for (Entity entity : world.getAllEntities()) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (entity instanceof Player) continue;
                    Location entityLoc = new Location(entity);
                    for (Location loc : locations) {
                        if (!Objects.equals(loc.level(), entityLoc.level()) || loc.squareDistanceTo(entityLoc) > radius || AttributeUtil.getModifier(living, (Holder<Attribute>)Attributes.SCALE, CommandConstants.SCALE_MODIFIER_UUID).map(AttributeModifier::amount).orElse(0.0) == this.level) continue;
                        AttributeUtil.addModifier(living, (Holder<Attribute>)Attributes.SCALE, CommandConstants.SCALE_MODIFIER_UUID, this.level, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, true);
                        success = true;
                        continue block1;
                    }
                }
            }
            if (!success) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not find entities to resize");
            }
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }, this.plugin.getSyncExecutor()));
    }

    public static EntitySizeCommand increase(ModdedCrowdControlPlugin plugin) {
        return new EntitySizeCommand(plugin, "entity_size_double", 1.0);
    }

    public static EntitySizeCommand decrease(ModdedCrowdControlPlugin plugin) {
        return new EntitySizeCommand(plugin, "entity_size_halve", -0.5);
    }

    @Generated
    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Generated
    public double getLevel() {
        return this.level;
    }
}

