/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.event.Join;
import dev.qixils.crowdcontrol.plugin.fabric.event.Listener;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;

public class GameModeCommand
extends ModdedCommand
implements CCTimedEffect {
    private final Duration defaultDuration;
    private final GameType gamemode;
    private final Component displayName;
    private final String effectName;
    private final Map<UUID, List<UUID>> activeRequests = new HashMap<UUID, List<UUID>>();
    private final String effectGroup = "gamemode";
    private final List<String> effectGroups = Collections.singletonList("gamemode");

    public GameModeCommand(ModdedCrowdControlPlugin plugin, GameType gamemode, long seconds) {
        super(plugin);
        this.defaultDuration = Duration.ofSeconds(seconds);
        this.gamemode = gamemode;
        this.displayName = plugin.toAdventure(gamemode.getLongDisplayName());
        this.effectName = gamemode.getName() + "_mode";
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isActive(ccPlayer, this.getEffectArray())) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Conflicting effects active");
            }
            List players = (List)playerSupplier.get();
            this.activeRequests.put(request.getRequestId(), players.stream().map(Entity::getUUID).toList());
            this.setGameMode(players, this.gamemode, true);
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }, this.plugin.getSyncExecutor()));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        List<ServerPlayer> players = this.plugin.toPlayerList((Collection<UUID>)this.activeRequests.remove(request.getRequestId()));
        this.setGameMode(players, GameType.SURVIVAL, false);
    }

    private void setGameMode(@NotNull @NotNull List<@NotNull ServerPlayer> players, @NotNull GameType gamemode, boolean enabling) {
        if (players.isEmpty()) {
            return;
        }
        this.sync(() -> players.forEach(player -> {
            player.setGameMode(gamemode);
            player.cc$setGameTypeEffect((GameType)(enabling ? gamemode : null));
        }));
    }

    @Generated
    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    @Generated
    public GameType getGamemode() {
        return this.gamemode;
    }

    @Override
    @Generated
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Generated
    public Map<UUID, List<UUID>> getActiveRequests() {
        return this.activeRequests;
    }

    @Generated
    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    @Generated
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }

    public static final class Manager {
        @Listener
        public void onJoin(Join event) {
            ServerPlayer player = event.player();
            GameType gameMode = player.cc$getGameTypeEffect();
            if (gameMode == null) {
                return;
            }
            player.cc$setGameTypeEffect(null);
            player.setGameMode(GameType.SURVIVAL);
        }
    }
}

