/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.LimitConfig;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.EntityCommand;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;

public class RemoveEntityCommand<E extends Entity>
extends ModdedCommand
implements EntityCommand<E> {
    protected final EntityType<? extends E> entityType;
    protected final List<EntityType<? extends E>> entityTypes;
    private final String effectName;
    private final Component displayName;
    private final String image = "remove_entity_creeper";
    private final int price = 250;
    private final byte priority = (byte)-5;
    private final List<String> categories = Collections.singletonList("Remove Entity");

    public RemoveEntityCommand(ModdedCrowdControlPlugin plugin, EntityType<E> entityType) {
        this(plugin, "remove_entity_" + CommandConstants.csIdOf((Keyed)BuiltInRegistries.ENTITY_TYPE.getKey(entityType)), (Component)Component.translatable((String)"cc.effect.remove_entity.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(entityType.getDescription())}), entityType, new EntityType[0]);
    }

    @SafeVarargs
    public RemoveEntityCommand(ModdedCrowdControlPlugin plugin, String effectName, @Nullable Component displayName, EntityType<? extends E> firstEntity, EntityType<? extends E> ... otherEntities) {
        super(plugin);
        this.entityType = firstEntity;
        this.entityTypes = new ArrayList<EntityType<? extends E>>(1 + otherEntities.length);
        this.entityTypes.add(firstEntity);
        this.entityTypes.addAll(Arrays.asList(otherEntities));
        this.effectName = effectName;
        this.displayName = displayName;
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getDefaultDisplayName();
    }

    @Override
    public boolean isMonster() {
        if (this.entityType == EntityType.ENDER_DRAGON) {
            return false;
        }
        return EntityCommand.super.isMonster();
    }

    private boolean removeEntityFrom(ServerPlayer player) {
        ServerLevel level = player.level();
        if (this.entityType == EntityType.ENDER_DRAGON && level.getDragonFight() != null) {
            return false;
        }
        Vec3 playerPosition = player.position();
        List<Entity> entities = StreamSupport.stream(level.getAllEntities().spliterator(), false).filter(entity -> this.getEntityTypes().contains(entity.getType()) && entity.distanceToSqr(playerPosition) <= 1225.0).sorted((entity1, entity2) -> (int)(entity1.distanceToSqr(playerPosition) - entity2.distanceToSqr(playerPosition))).toList();
        if (entities.isEmpty()) {
            return false;
        }
        entities.getFirst().remove(Entity.RemovalReason.KILLED);
        return true;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            LimitConfig config = this.getPlugin().getLimitConfig();
            int playerLimit = config.getEntityLimit(BuiltInRegistries.ENTITY_TYPE.getKey(this.entityType).getPath());
            CCEffectResponse tryExecute = this.tryExecute(players, request, ccPlayer);
            if (tryExecute != null) {
                return tryExecute;
            }
            return this.executeLimit(request, players, playerLimit, player -> CompletableFuture.supplyAsync(() -> {
                boolean success = false;
                try {
                    success = this.removeEntityFrom((ServerPlayer)player);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No " + this.plugin.getTextUtil().asPlain(this.entityType.getDescription()) + "s found nearby to remove");
            }, this.getPlugin().getSyncExecutor()).join());
        }));
    }

    @Override
    @Generated
    public EntityType<? extends E> getEntityType() {
        return this.entityType;
    }

    @Generated
    public List<EntityType<? extends E>> getEntityTypes() {
        return this.entityTypes;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @Generated
    public String getImage() {
        return this.image;
    }

    @Override
    @Generated
    public int getPrice() {
        return this.price;
    }

    @Override
    @Generated
    public byte getPriority() {
        return this.priority;
    }

    @Override
    @Generated
    public List<String> getCategories() {
        return this.categories;
    }
}

