/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import com.mojang.datafixers.util.Pair;
import dev.qixils.crowdcontrol.common.util.TextUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.NearbyLocationCommand;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;

public class StructureCommand
extends NearbyLocationCommand<StructureGroup> {
    private static final Map<ResourceKey<Level>, List<StructureGroup>> STRUCTURES = Map.of(Level.OVERWORLD, List.of(StructureGroup.VILLAGE, StructureGroup.PILLAGER_OUTPOST, StructureGroup.MINESHAFT, StructureGroup.WOODLAND_MANSION, StructureGroup.JUNGLE_TEMPLE, StructureGroup.DESERT_PYRAMID, StructureGroup.IGLOO, StructureGroup.SHIPWRECK, StructureGroup.SWAMP_HUT, StructureGroup.STRONGHOLD, StructureGroup.OCEAN_MONUMENT, StructureGroup.OCEAN_RUIN, StructureGroup.BURIED_TREASURE, StructureGroup.RUINED_PORTAL), Level.NETHER, List.of(StructureGroup.NETHER_FORTRESS, StructureGroup.BASTION_REMNANT, StructureGroup.RUINED_PORTAL_NETHER), Level.END, List.of(StructureGroup.END_CITY));
    private final String effectName = "structure";

    public StructureCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    @Nullable
    protected Location search(@NotNull Location origin, @NotNull StructureGroup searchType) {
        Pair pair = origin.level().getChunkSource().getGenerator().findNearestMapStructure(origin.level(), searchType.getStructures(origin.level()), origin.pos(), 64, false);
        if (pair == null) {
            return null;
        }
        return new Location(origin.level(), (BlockPos)pair.getFirst());
    }

    @Override
    @NotNull
    protected Collection<StructureGroup> getSearchTypes(@NotNull ServerLevel level) {
        return STRUCTURES.get(level.dimension());
    }

    @Override
    @NotNull
    protected Component nameOf(@NotNull StructureGroup searchType) {
        return searchType.name;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    static enum StructureGroup {
        PILLAGER_OUTPOST(BuiltinStructures.PILLAGER_OUTPOST),
        MINESHAFT(BuiltinStructures.MINESHAFT, BuiltinStructures.MINESHAFT_MESA),
        WOODLAND_MANSION(BuiltinStructures.WOODLAND_MANSION),
        JUNGLE_TEMPLE(BuiltinStructures.JUNGLE_TEMPLE),
        DESERT_PYRAMID(BuiltinStructures.DESERT_PYRAMID),
        IGLOO(BuiltinStructures.IGLOO),
        SHIPWRECK(BuiltinStructures.SHIPWRECK, BuiltinStructures.SHIPWRECK_BEACHED),
        SWAMP_HUT(BuiltinStructures.SWAMP_HUT),
        STRONGHOLD(BuiltinStructures.STRONGHOLD),
        OCEAN_MONUMENT(BuiltinStructures.OCEAN_MONUMENT),
        OCEAN_RUIN(BuiltinStructures.OCEAN_RUIN_COLD, BuiltinStructures.OCEAN_RUIN_WARM),
        NETHER_FORTRESS("Fortress", BuiltinStructures.FORTRESS),
        NETHER_FOSSIL(BuiltinStructures.NETHER_FOSSIL),
        END_CITY(BuiltinStructures.END_CITY),
        BURIED_TREASURE(BuiltinStructures.BURIED_TREASURE),
        BASTION_REMNANT(BuiltinStructures.BASTION_REMNANT),
        VILLAGE(BuiltinStructures.VILLAGE_PLAINS, BuiltinStructures.VILLAGE_SAVANNA, BuiltinStructures.VILLAGE_SNOWY, BuiltinStructures.VILLAGE_TAIGA, BuiltinStructures.VILLAGE_DESERT),
        RUINED_PORTAL(BuiltinStructures.RUINED_PORTAL_STANDARD, BuiltinStructures.RUINED_PORTAL_DESERT, BuiltinStructures.RUINED_PORTAL_JUNGLE, BuiltinStructures.RUINED_PORTAL_SWAMP, BuiltinStructures.RUINED_PORTAL_MOUNTAIN, BuiltinStructures.RUINED_PORTAL_OCEAN),
        RUINED_PORTAL_NETHER("Ruined Portal", BuiltinStructures.RUINED_PORTAL_NETHER),
        ANCIENT_CITY(BuiltinStructures.ANCIENT_CITY);

        private final Component name;
        private final ResourceKey<Structure>[] structures;

        @SafeVarargs
        private StructureGroup(String name, ResourceKey<Structure> ... structures) {
            this((Component)Component.text((String)name), structures);
        }

        @SafeVarargs
        private StructureGroup(Component name, ResourceKey<Structure> ... structures) {
            this.name = name;
            this.structures = structures;
        }

        @SafeVarargs
        private StructureGroup(ResourceKey<Structure> ... structures) {
            this.name = Component.text((String)TextUtil.titleCase(this));
            this.structures = structures;
        }

        HolderSet<Structure> getStructures(ServerLevel level) {
            Registry registry = level.registryAccess().lookupOrThrow(Registries.STRUCTURE);
            return HolderSet.direct(Arrays.stream(this.structures).map(arg_0 -> ((Registry)registry).get(arg_0)).flatMap(Optional::stream).toList());
        }
    }
}

