/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands.executeorperish;

import dev.qixils.crowdcontrol.plugin.fabric.commands.executeorperish.ConditionFlags;
import dev.qixils.crowdcontrol.plugin.fabric.commands.executeorperish.CraftItemCondition;
import dev.qixils.crowdcontrol.plugin.fabric.commands.executeorperish.JumpingJacksCondition;
import dev.qixils.crowdcontrol.plugin.fabric.commands.executeorperish.ObtainItemCondition;
import dev.qixils.crowdcontrol.plugin.fabric.commands.executeorperish.StandOnBlockCondition;
import dev.qixils.crowdcontrol.plugin.fabric.commands.executeorperish.SuccessCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;

public enum Condition {
    STAND_ON_COBBLESTONE(new StandOnBlockCondition(2, "generic", Blocks.COBBLESTONE)),
    STAND_ON_A_PLANK(new StandOnBlockCondition(2, "plank", Blocks.OAK_PLANKS, Blocks.BIRCH_PLANKS, Blocks.ACACIA_PLANKS, Blocks.CRIMSON_PLANKS, Blocks.JUNGLE_PLANKS, Blocks.WARPED_PLANKS, Blocks.DARK_OAK_PLANKS, Blocks.SPRUCE_PLANKS)),
    STAND_ON_A_STRIPPED_LOG(new StandOnBlockCondition(5, "stripped_log", Blocks.STRIPPED_OAK_LOG, Blocks.STRIPPED_BIRCH_LOG, Blocks.STRIPPED_ACACIA_LOG, Blocks.STRIPPED_JUNGLE_LOG, Blocks.STRIPPED_DARK_OAK_LOG, Blocks.STRIPPED_SPRUCE_LOG, Blocks.STRIPPED_CRIMSON_STEM, Blocks.STRIPPED_WARPED_STEM, Blocks.STRIPPED_OAK_WOOD, Blocks.STRIPPED_BIRCH_WOOD, Blocks.STRIPPED_ACACIA_WOOD, Blocks.STRIPPED_JUNGLE_WOOD, Blocks.STRIPPED_DARK_OAK_WOOD, Blocks.STRIPPED_SPRUCE_WOOD, Blocks.STRIPPED_CRIMSON_HYPHAE, Blocks.STRIPPED_WARPED_HYPHAE)),
    OBTAIN_STONE(new ObtainItemCondition(4, "generic_block", Items.STONE)),
    CRAFT_STONE_HOE(new CraftItemCondition(3, "generic", Items.STONE_HOE)),
    CRAFT_WOODEN_HOE(new CraftItemCondition(2, "generic", Items.WOODEN_HOE)),
    STAND_ON_DIRT(new StandOnBlockCondition(2, "generic", ConditionFlags.OVERWORLD, Blocks.DIRT)),
    STAND_ON_STONE(new StandOnBlockCondition(2, "generic", ConditionFlags.OVERWORLD, Blocks.STONE)),
    STAND_ON_SAND(new StandOnBlockCondition(2, "generic", ConditionFlags.OVERWORLD, Blocks.SAND)),
    STAND_ON_A_BED(new StandOnBlockCondition(4, "bed", ConditionFlags.OVERWORLD, Blocks.WHITE_BED, Blocks.ORANGE_BED, Blocks.MAGENTA_BED, Blocks.LIGHT_BLUE_BED, Blocks.YELLOW_BED, Blocks.LIME_BED, Blocks.PINK_BED, Blocks.GRAY_BED, Blocks.LIGHT_GRAY_BED, Blocks.CYAN_BED, Blocks.PURPLE_BED, Blocks.BLUE_BED, Blocks.BROWN_BED, Blocks.GREEN_BED, Blocks.RED_BED, Blocks.BLACK_BED)),
    OBTAIN_WHEAT_SEEDS(new ObtainItemCondition(2, "generic_alt", ConditionFlags.OVERWORLD, Items.WHEAT_SEEDS)),
    CRAFT_SANDSTONE(new CraftItemCondition(2, "generic_block", Items.SANDSTONE, ConditionFlags.OVERWORLD)),
    STAND_ON_FIRE(new StandOnBlockCondition(2, "generic", ConditionFlags.NETHER, Blocks.FIRE)),
    OBTAIN_NETHER_BRICK(new ObtainItemCondition(4, "generic", ConditionFlags.NETHER, Items.NETHER_BRICK)),
    OBTAIN_OBSIDIAN(new ObtainItemCondition(4, "generic_alt", ConditionFlags.NETHER, Items.OBSIDIAN)),
    CRAFT_QUARTZ(new CraftItemCondition(2, "generic", Items.QUARTZ_BLOCK, ConditionFlags.NETHER)),
    CRAFT_GOLD_INGOT(new CraftItemCondition(2, "generic", Items.GOLD_INGOT, ConditionFlags.NETHER)),
    CRAFT_GLOWSTONE(new CraftItemCondition(2, "generic_block", Items.GLOWSTONE, ConditionFlags.NETHER)),
    JUMP(new JumpingJacksCondition(49));

    private static final List<SuccessCondition> CONDITIONS;
    private final SuccessCondition condition;

    public static List<SuccessCondition> items() {
        return CONDITIONS;
    }

    @Generated
    private Condition(SuccessCondition condition) {
        this.condition = condition;
    }

    @Generated
    public SuccessCondition getCondition() {
        return this.condition;
    }

    static {
        ArrayList<SuccessCondition> conditions = new ArrayList<SuccessCondition>(Condition.values().length);
        for (Condition cond : Condition.values()) {
            conditions.add(cond.getCondition());
        }
        CONDITIONS = Collections.unmodifiableList(conditions);
    }
}

