/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands.executeorperish;

import dev.qixils.crowdcontrol.plugin.fabric.utils.InventoryUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class ConditionFlags
implements Predicate<ServerPlayer> {
    @NotNull
    public static final ConditionFlags DEFAULT = ConditionFlags.builder().build();
    @NotNull
    public static final ConditionFlags OVERWORLD = ConditionFlags.builder().allowedDimensions(Collections.singletonList(Level.OVERWORLD)).build();
    @NotNull
    public static final ConditionFlags NETHER = ConditionFlags.builder().allowedDimensions(Collections.singletonList(Level.NETHER)).build();
    @NotNull
    public static final ConditionFlags THE_END = ConditionFlags.builder().allowedDimensions(Collections.singletonList(Level.END)).build();
    @NotNull
    private final List<ResourceKey<Level>> allowedDimensions;
    @NotNull
    private final Map<Item, Integer> requiredItems;

    @Override
    public boolean test(@NotNull ServerPlayer player) {
        if (!this.allowedDimensions.isEmpty() && !this.allowedDimensions.contains(player.level().dimension())) {
            return false;
        }
        for (Map.Entry<Item, Integer> entry : this.requiredItems.entrySet()) {
            Item item = entry.getKey();
            int required = entry.getValue();
            int count = 0;
            for (ItemStack stack : InventoryUtil.viewAllItems(player.getInventory())) {
                if (stack != null && stack.getItem() == item && (count += stack.getCount()) >= required) break;
            }
            if (count >= required) continue;
            return false;
        }
        return true;
    }

    @Generated
    private static List<ResourceKey<Level>> $default$allowedDimensions() {
        return Collections.emptyList();
    }

    @Generated
    private static Map<Item, Integer> $default$requiredItems() {
        return Collections.emptyMap();
    }

    @Generated
    ConditionFlags(@NotNull List<ResourceKey<Level>> allowedDimensions, @NotNull Map<Item, Integer> requiredItems) {
        if (allowedDimensions == null) {
            throw new NullPointerException("allowedDimensions is marked non-null but is null");
        }
        if (requiredItems == null) {
            throw new NullPointerException("requiredItems is marked non-null but is null");
        }
        this.allowedDimensions = allowedDimensions;
        this.requiredItems = requiredItems;
    }

    @Generated
    public static ConditionFlagsBuilder builder() {
        return new ConditionFlagsBuilder();
    }

    @NotNull
    @Generated
    public List<ResourceKey<Level>> getAllowedDimensions() {
        return this.allowedDimensions;
    }

    @NotNull
    @Generated
    public Map<Item, Integer> getRequiredItems() {
        return this.requiredItems;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionFlags)) {
            return false;
        }
        ConditionFlags other = (ConditionFlags)o;
        List<ResourceKey<Level>> this$allowedDimensions = this.getAllowedDimensions();
        List<ResourceKey<Level>> other$allowedDimensions = other.getAllowedDimensions();
        if (this$allowedDimensions == null ? other$allowedDimensions != null : !((Object)this$allowedDimensions).equals(other$allowedDimensions)) {
            return false;
        }
        Map<Item, Integer> this$requiredItems = this.getRequiredItems();
        Map<Item, Integer> other$requiredItems = other.getRequiredItems();
        return !(this$requiredItems == null ? other$requiredItems != null : !((Object)this$requiredItems).equals(other$requiredItems));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ResourceKey<Level>> $allowedDimensions = this.getAllowedDimensions();
        result = result * 59 + ($allowedDimensions == null ? 43 : ((Object)$allowedDimensions).hashCode());
        Map<Item, Integer> $requiredItems = this.getRequiredItems();
        result = result * 59 + ($requiredItems == null ? 43 : ((Object)$requiredItems).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConditionFlags(allowedDimensions=" + String.valueOf(this.getAllowedDimensions()) + ", requiredItems=" + String.valueOf(this.getRequiredItems()) + ")";
    }

    @Generated
    public static class ConditionFlagsBuilder {
        @Generated
        private boolean allowedDimensions$set;
        @Generated
        private List<ResourceKey<Level>> allowedDimensions$value;
        @Generated
        private boolean requiredItems$set;
        @Generated
        private Map<Item, Integer> requiredItems$value;

        @Generated
        ConditionFlagsBuilder() {
        }

        @Generated
        public ConditionFlagsBuilder allowedDimensions(@NotNull List<ResourceKey<Level>> allowedDimensions) {
            if (allowedDimensions == null) {
                throw new NullPointerException("allowedDimensions is marked non-null but is null");
            }
            this.allowedDimensions$value = allowedDimensions;
            this.allowedDimensions$set = true;
            return this;
        }

        @Generated
        public ConditionFlagsBuilder requiredItems(@NotNull Map<Item, Integer> requiredItems) {
            if (requiredItems == null) {
                throw new NullPointerException("requiredItems is marked non-null but is null");
            }
            this.requiredItems$value = requiredItems;
            this.requiredItems$set = true;
            return this;
        }

        @Generated
        public ConditionFlags build() {
            List<ResourceKey<Level>> allowedDimensions$value = this.allowedDimensions$value;
            if (!this.allowedDimensions$set) {
                allowedDimensions$value = ConditionFlags.$default$allowedDimensions();
            }
            Map<Item, Integer> requiredItems$value = this.requiredItems$value;
            if (!this.requiredItems$set) {
                requiredItems$value = ConditionFlags.$default$requiredItems();
            }
            return new ConditionFlags(allowedDimensions$value, requiredItems$value);
        }

        @Generated
        public String toString() {
            return "ConditionFlags.ConditionFlagsBuilder(allowedDimensions$value=" + String.valueOf(this.allowedDimensions$value) + ", requiredItems$value=" + String.valueOf(this.requiredItems$value) + ")";
        }
    }
}

