/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.util;

import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.relocated.annotations.Contract;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import dev.qixils.relocated.annotations.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public abstract class AbstractBlockFinder<L, V, W> {
    protected final W origin;
    protected final List<V> positions;
    protected final Predicate<L> locationValidator;
    private final List<L> allLocations = new ArrayList<L>();

    protected AbstractBlockFinder(@NotNull W origin, @NotNull List<V> positions, @NotNull Predicate<L> locationValidator) {
        this.origin = origin;
        this.positions = positions;
        this.locationValidator = locationValidator;
    }

    protected abstract L getLocation(V var1);

    @Nullable
    public L next() {
        if (this.positions.isEmpty()) {
            return null;
        }
        L location = this.getLocation(this.positions.remove(0));
        if (this.locationValidator.test(location)) {
            this.allLocations.add(location);
            return location;
        }
        return this.next();
    }

    @NotNull
    public List<L> getAll() {
        L next = this.next();
        while (next != null) {
            this.allLocations.add(next);
            next = this.next();
        }
        return Collections.unmodifiableList(this.allLocations);
    }

    public static abstract class AbstractBlockFinderBuilder<B extends AbstractBlockFinderBuilder<B, F, L, V, W>, F extends AbstractBlockFinder<L, V, W>, L, V, W> {
        protected W originWorld;
        protected V originPos;
        protected int maxRadius = 0;
        protected int minRadius = 0;
        protected boolean shuffleLocations = true;
        protected Predicate<L> locationValidator;

        @NotNull
        @Contract(value="_ -> this")
        public B maxRadius(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) int maxRadius) {
            this.maxRadius = maxRadius;
            return (B)this;
        }

        @NotNull
        @Contract(value="_ -> this")
        public B minRadius(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) int minRadius) {
            this.minRadius = minRadius;
            return (B)this;
        }

        @NotNull
        @Contract(value="_ -> this")
        public B shuffleLocations(boolean shuffleLocations) {
            this.shuffleLocations = shuffleLocations;
            return (B)this;
        }

        @NotNull
        @Contract(value="_ -> this")
        public B originPos(@Nullable V originPos) {
            this.originPos = originPos;
            return (B)this;
        }

        @NotNull
        @Contract(value="_ -> this")
        public B originWorld(@Nullable W originWorld) {
            this.originWorld = originWorld;
            return (B)this;
        }

        @NotNull
        @Contract(value="_ -> this")
        public abstract B origin(@Nullable L var1);

        @NotNull
        @Contract(value="_ -> this")
        public B locationValidator(@Nullable Predicate<@NotNull L> validator) {
            this.locationValidator = validator;
            return (B)this;
        }

        protected abstract int getFloorX(@NotNull V var1);

        protected abstract int getFloorY(@NotNull V var1);

        protected abstract int getFloorZ(@NotNull V var1);

        @NotNull
        protected abstract V createVector(int var1, int var2, int var3);

        @NotNull
        protected List<V> preBuildDataInit() throws IllegalStateException {
            if (this.maxRadius <= 0) {
                throw new IllegalStateException("maxRadius must be greater than 0");
            }
            if (this.originWorld == null) {
                throw new IllegalStateException("originWorld is not set");
            }
            if (this.locationValidator == null) {
                this.locationValidator = $ -> true;
            }
            ArrayList<V> locations = new ArrayList<V>((int)(Math.pow(this.maxRadius, 3.0) - Math.pow(this.minRadius, 3.0)));
            int origX = this.getFloorX(this.originPos);
            int origY = this.getFloorY(this.originPos);
            int origZ = this.getFloorZ(this.originPos);
            for (int x = -this.maxRadius; x <= this.maxRadius; ++x) {
                if (Math.abs(x) < this.minRadius) continue;
                for (int y = -this.maxRadius; y <= this.maxRadius; ++y) {
                    if (Math.abs(y) < this.minRadius) continue;
                    for (int z = -this.maxRadius; z <= this.maxRadius; ++z) {
                        if (Math.abs(z) < this.minRadius) continue;
                        locations.add(this.createVector(origX + x, origY + y, origZ + z));
                    }
                }
            }
            if (this.shuffleLocations) {
                Collections.shuffle(locations, RandomUtil.RNG);
            }
            return locations;
        }

        public abstract AbstractBlockFinder<L, V, W> build() throws IllegalStateException;
    }
}

