/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric;

import dev.qixils.crowdcontrol.common.EntityMapper;
import dev.qixils.crowdcontrol.common.util.PermissionWrapper;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.PermissionSource;
import net.minecraft.world.entity.Entity;

public class CommandSourceStackMapper
implements EntityMapper<CommandSourceStack> {
    protected final ModdedCrowdControlPlugin plugin;

    protected CommandSourceStackMapper(ModdedCrowdControlPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public Audience asAudience(@NotNull CommandSourceStack entity) {
        return this.plugin.adventure().audience(entity);
    }

    @Override
    @NotNull
    public final Optional<UUID> tryGetUniqueId(@NotNull CommandSourceStack entity) {
        return Optional.ofNullable(entity.getEntity()).map(Entity::getUUID).or(() -> entity.get(Identity.UUID));
    }

    @Override
    public boolean hasPermission(@NotNull CommandSourceStack entity, @NotNull PermissionWrapper perm) {
        return this.plugin.getPermissionUtil().check((PermissionSource)entity, perm);
    }

    public ModdedCrowdControlPlugin getPlugin() {
        return this.plugin;
    }
}

