/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric;

import dev.qixils.crowdcontrol.common.SoftLockObserver;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.event.Death;
import dev.qixils.crowdcontrol.plugin.fabric.event.Listener;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class SoftLockResolver
extends SoftLockObserver<ServerPlayer> {
    @NotNull
    private final Collection<Block> dangerousBlocks = List.of(Blocks.LAVA, Blocks.FIRE, Blocks.WITHER_ROSE);
    @NotNull
    private final TargetingConditions conditions = TargetingConditions.forNonCombat().ignoreLineOfSight().ignoreInvisibilityTesting().range((double)this.getSearchH());

    public SoftLockResolver(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void onSoftLock(ServerPlayer player) {
        for (Mob entity : player.level().getNearbyEntities(Mob.class, this.conditions, (LivingEntity)player, AABB.ofSize((Vec3)player.position(), (double)(this.getSearchH() * 2), (double)(this.getSearchV() * 2), (double)(this.getSearchH() * 2)))) {
            if (!(entity instanceof Enemy)) continue;
            entity.remove(Entity.RemovalReason.KILLED);
        }
        for (int x = -this.getSearchH(); x <= this.getSearchH(); ++x) {
            for (int y = -this.getSearchV(); y <= this.getSearchV(); ++y) {
                for (int z = -this.getSearchH(); z <= this.getSearchH(); ++z) {
                    BlockPos pos;
                    ServerLevel level = player.level();
                    BlockState block = level.getBlockState(pos = BlockPos.containing((Position)player.position().add((double)x, (double)y, (double)z)));
                    if (!this.dangerousBlocks.contains(block.getBlock())) continue;
                    level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                }
            }
        }
        player.sendMessage(ALERT);
    }

    @Listener
    public void onDeathEvent(Death death) {
        LivingEntity livingEntity = death.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            this.onDeath(player);
        }
    }
}

