/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.common.util.sound.Sounds;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;

public class KeepInventoryCommand
extends ModdedCommand {
    private static final Set<UUID> keepingInventory = Collections.synchronizedSet(new HashSet(1));
    public static boolean globalKeepInventory = false;
    private final boolean enable;
    private final String effectName;

    public KeepInventoryCommand(ModdedCrowdControlPlugin plugin, boolean enable) {
        super(plugin);
        this.enable = enable;
        this.effectName = "keep_inventory_" + (enable ? "on" : "off");
    }

    public static boolean isKeepingInventory(UUID player) {
        return globalKeepInventory || keepingInventory.contains(player);
    }

    public static boolean isKeepingInventory(Entity player) {
        return KeepInventoryCommand.isKeepingInventory(player.getUUID());
    }

    private void alert(List<ServerPlayer> players) {
        Audience audience = this.plugin.playerMapper().asAudience(players);
        audience.sendActionBar(this.enable ? CommandConstants.KEEP_INVENTORY_MESSAGE : CommandConstants.LOSE_INVENTORY_MESSAGE);
        audience.playSound((this.enable ? Sounds.KEEP_INVENTORY_ALERT : Sounds.LOSE_INVENTORY_ALERT).get(new Object[0]), Sound.Emitter.self());
    }

    @Override
    public void execute(@NotNull Supplier<List<ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            if (this.plugin.isGlobal()) {
                if (globalKeepInventory == this.enable) {
                    return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Keep Inventory is already " + (this.enable ? "enabled" : "disabled"));
                }
                globalKeepInventory = this.enable;
                this.alert(players);
                this.plugin.updateConditionalEffectVisibility();
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
            }
            ArrayList<UUID> uuids = new ArrayList<UUID>(players.size());
            for (ServerPlayer player : players) {
                uuids.add(player.getUUID());
            }
            if (this.enable) {
                if (keepingInventory.addAll(uuids)) {
                    this.alert(players);
                    players.forEach(this.plugin::updateConditionalEffectVisibility);
                    return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
                }
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Streamer(s) already have Keep Inventory enabled");
            }
            if (keepingInventory.removeAll(uuids)) {
                this.alert(players);
                players.forEach(this.plugin::updateConditionalEffectVisibility);
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
            }
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Streamer(s) already have Keep Inventory disabled");
        }));
    }

    @Override
    public TriState isVisible(@NotNull IUserRecord user, @NotNull List<ServerPlayer> potentialPlayers) {
        return potentialPlayers.stream().anyMatch(player -> player.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) ? TriState.FALSE : TriState.TRUE;
    }

    @Override
    public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<ServerPlayer> potentialPlayers) {
        if (this.plugin.isGlobal()) {
            return globalKeepInventory == this.enable ? TriState.FALSE : TriState.TRUE;
        }
        TriState state = potentialPlayers.stream().map(player -> TriState.fromBoolean(this.enable != KeepInventoryCommand.isKeepingInventory(player.getUUID()))).reduce((prev, next) -> {
            if (prev != next) {
                return TriState.UNKNOWN;
            }
            return prev;
        }).orElse(TriState.UNKNOWN);
        if (state == TriState.FALSE) {
            return state;
        }
        return TriState.TRUE;
    }

    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

