/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

abstract class NearbyLocationCommand<S>
extends ModdedCommand {
    private final List<String> effectGroups = List.of("walk", "look");

    protected NearbyLocationCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Nullable
    private static Location highestLocation(@Nullable Location origin) {
        if (origin == null) {
            return null;
        }
        int air = 0;
        ServerLevel world = origin.level();
        Location location = new Location(world, origin.x(), world.getLogicalHeight() - 1, origin.z(), origin.yaw(), origin.pitch());
        while (true) {
            BlockState block = location.block();
            if (location.y() < (double)(world.getMinY() + 1)) {
                return null;
            }
            if (block.getBlock().isPossibleToRespawnInThis(block) && !block.blocksMotion()) {
                ++air;
            } else {
                if (air >= 1) break;
                air = 0;
            }
            location = location.add(0.0, -1.0, 0.0);
        }
        return location;
    }

    @Nullable
    private static Location safeLocation(@Nullable Location origin) {
        Location location = NearbyLocationCommand.highestLocation(origin);
        if (location == null) {
            return null;
        }
        BlockState block = location.block();
        Block type = block.getBlock();
        if (Blocks.FIRE.equals(type)) {
            location.block(Blocks.AIR.defaultBlockState());
        } else if (!block.blocksMotion()) {
            location.block(Blocks.GLASS.defaultBlockState());
        }
        location = location.add(0.5, 1.0, 0.5);
        return location;
    }

    @Nullable
    protected abstract Location search(@NotNull Location var1, @NotNull S var2);

    @NotNull
    protected abstract Collection<S> getSearchTypes(@NotNull ServerLevel var1);

    @NotNull
    protected abstract Component nameOf(@NotNull S var1);

    @Nullable
    protected S currentType(@NotNull Location origin) {
        return null;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isArrayActive(ccPlayer)) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot teleport while frozen");
            }
            boolean success = false;
            block0: for (ServerPlayer player : (List)playerSupplier.get()) {
                ServerLevel world = player.level();
                Location location = new Location((Entity)player);
                S currentType = this.currentType(location);
                ArrayList<S> searchTypes = new ArrayList<S>(this.getSearchTypes(world));
                Collections.shuffle(searchTypes, random);
                for (Object searchType : searchTypes) {
                    Location target;
                    if (searchType.equals(currentType) || (target = this.search(location, searchType)) == null) continue;
                    Location destination = NearbyLocationCommand.safeLocation(target);
                    if (destination == null) {
                        this.plugin.getSLF4JLogger().debug("Skipping {} because it is not safe", searchType);
                        continue;
                    }
                    if (Mth.lengthSquared((double)(destination.x() - location.x()), (double)(destination.z() - location.z())) <= 2500.0 || !world.getWorldBorder().isWithinBounds(destination.x(), destination.z())) continue;
                    player.teleportTo(destination.x(), destination.y(), destination.z());
                    player.sendActionBar((Component)Component.translatable((String)"cc.effect.nearby_location.output", (ComponentLike[])new ComponentLike[]{this.nameOf(searchType).color((TextColor)NamedTextColor.YELLOW)}));
                    success = true;
                    continue block0;
                }
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not find a location to teleport to");
        }, this.plugin.getSyncExecutor()));
    }

    @Override
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }
}

