/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.BlockFinder;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RandomFallingBlockCommand
extends ModdedCommand {
    private final String effectName = "falling_block_random";
    private final Map<ServerLevel, List<Block>> blocks = new WeakHashMap<ServerLevel, List<Block>>();

    public RandomFallingBlockCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    public Block getRandomBlock(ServerLevel level) {
        return (Block)RandomUtil.randomElementFrom(this.blocks.computeIfAbsent(level, $ -> BuiltInRegistries.BLOCK.stream().filter(block -> block.defaultBlockState().isSolid() && block.defaultBlockState().canOcclude() && block.isEnabled(level.enabledFeatures())).toList()));
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            boolean success = false;
            block0: for (ServerPlayer player : (List)playerSupplier.get()) {
                Location playerLoc = new Location((Entity)player);
                ServerLevel world = player.level();
                BlockPos position = BlockPos.containing((double)playerLoc.x(), (double)Math.min(playerLoc.y() + 5.0, (double)(world.getMaxY() - 1)), (double)playerLoc.z());
                for (int y = (int)Math.floor(playerLoc.y() + 1.0); y < position.getY(); ++y) {
                    BlockState block = world.getBlockState(new BlockPos(position.getX(), y, position.getZ()));
                    if (!BlockFinder.isPassable(block)) continue block0;
                }
                Block block = this.getRandomBlock(player.level());
                FallingBlockEntity entity = FallingBlockEntity.fall((Level)player.level(), (BlockPos)position, (BlockState)block.defaultBlockState());
                entity.fallDamagePerDistance = 0.75f;
                entity.fallDamageMax = 4;
                entity.dropItem = true;
                success = true;
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Unable to find valid spawning location");
        }, this.plugin.getSyncExecutor()));
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

