/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class RespawnCommand
extends ModdedCommand {
    private final String effectName = "respawn";
    private final List<String> effectGroups = List.of("walk", "look");

    public RespawnCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    private void teleport(ServerPlayer player, ServerLevel level, BlockPos pos, float angle) {
        this.sync(() -> player.teleportTo(level, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, Collections.emptySet(), angle, 0.0f, false));
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isActive(ccPlayer, this.getEffectArray())) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot fling while frozen");
            }
            boolean success = false;
            for (ServerPlayer player : (List)playerSupplier.get()) {
                float angle;
                BlockPos pos;
                ServerLevel level;
                ServerPlayer.RespawnConfig respawnConfig = player.getRespawnConfig();
                if (respawnConfig == null) {
                    if (player.getServer() == null || (level = player.getServer().getLevel(Level.OVERWORLD)) == null) continue;
                    pos = level.getSharedSpawnPos();
                    angle = 0.0f;
                } else {
                    if (player.getServer() == null || (level = player.getServer().getLevel(respawnConfig.dimension())) == null) continue;
                    pos = respawnConfig.pos();
                    angle = respawnConfig.angle();
                }
                this.teleport(player, level, pos, angle);
                success = true;
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not find a respawn point");
        }));
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }
}

