/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.event;

import dev.qixils.crowdcontrol.plugin.fabric.event.CancellableEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;

public final class Damage
implements CancellableEvent {
    private final Entity entity;
    private final DamageSource source;
    private final float amount;
    private boolean cancelled = false;

    public Entity entity() {
        return this.entity;
    }

    public DamageSource source() {
        return this.source;
    }

    public float amount() {
        return this.amount;
    }

    @Override
    public boolean cancelled() {
        return this.cancelled;
    }

    @Override
    public void cancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Damage)) {
            return false;
        }
        Damage other = (Damage)o;
        if (Float.compare(this.amount(), other.amount()) != 0) {
            return false;
        }
        if (this.cancelled() != other.cancelled()) {
            return false;
        }
        Entity this$entity = this.entity();
        Entity other$entity = other.entity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        DamageSource this$source = this.source();
        DamageSource other$source = other.source();
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.amount());
        result = result * 59 + (this.cancelled() ? 79 : 97);
        Entity $entity = this.entity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        DamageSource $source = this.source();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }

    public String toString() {
        return "Damage(entity=" + String.valueOf(this.entity()) + ", source=" + String.valueOf(this.source()) + ", amount=" + this.amount() + ", cancelled=" + this.cancelled() + ")";
    }

    public Damage(Entity entity, DamageSource source, float amount) {
        this.entity = entity;
        this.source = source;
        this.amount = amount;
    }

    public Damage(Entity entity, DamageSource source, float amount, boolean cancelled) {
        this.entity = entity;
        this.source = source;
        this.amount = amount;
        this.cancelled = cancelled;
    }
}

