/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.mixin;

import dev.qixils.crowdcontrol.plugin.fabric.interfaces.Components;
import dev.qixils.crowdcontrol.plugin.fabric.interfaces.OriginalDisplayName;
import dev.qixils.crowdcontrol.plugin.fabric.interfaces.ViewerMob;
import dev.qixils.crowdcontrol.plugin.fabric.utils.EntityUtil;
import dev.qixils.relocated.annotations.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements ViewerMob,
OriginalDisplayName {
    @Unique
    boolean cc$isViewerSpawned;
    @Unique
    Component cc$originalDisplayName;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public boolean cc$isViewerSpawned() {
        return this.cc$isViewerSpawned;
    }

    @Override
    public void cc$setViewerSpawned(boolean isViewerSpawned) {
        this.cc$isViewerSpawned = isViewerSpawned;
    }

    @Override
    @Nullable
    public Component cc$getOriginalDisplayName() {
        return this.cc$originalDisplayName;
    }

    @Override
    public void cc$setOriginalDisplayName(@Nullable Component originalDisplayName) {
        this.cc$originalDisplayName = originalDisplayName;
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="TAIL")})
    void onReadAdditionalSaveData(ValueInput tag, CallbackInfo ci) {
        this.cc$isViewerSpawned = tag.getBooleanOr(Components.VIEWER_MOB, false);
        this.cc$originalDisplayName = tag.read(Components.ORIGINAL_DISPLAY_NAME, ComponentSerialization.CODEC).orElse(null);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="TAIL")})
    void onAddAdditionalSaveData(ValueOutput tag, CallbackInfo ci) {
        if (this.cc$isViewerSpawned) {
            tag.putBoolean(Components.VIEWER_MOB, true);
        }
        if (this.cc$originalDisplayName != null) {
            tag.store(Components.ORIGINAL_DISPLAY_NAME, ComponentSerialization.CODEC, (Object)this.cc$originalDisplayName);
        }
    }

    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void callDeathEvent(DamageSource cause, CallbackInfo ci) {
        EntityUtil.handleDie((LivingEntity)this, cause, ci);
    }

    @Inject(method={"jumpFromGround()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void jumpFromGround(CallbackInfo ci) {
    }
}

