/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.utils;

import dev.qixils.relocated.annotations.Contract;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class ParticleEffectBuilder<T extends ParticleOptions> {
    @NotNull
    private final T particleOptions;
    @Nullable
    private ServerLevel level = null;
    @Nullable
    private Vector3d position = null;
    @NotNull
    private Vector3f distance = new Vector3f(0.0f, 0.0f, 0.0f);
    private float maxSpeed = 0.1f;
    private int count = 1;

    @Contract(value="_ -> this")
    public ParticleEffectBuilder<T> position(Vector3d position) {
        this.position = new Vector3d(position.x, position.y, position.z);
        return this;
    }

    @Contract(value="_ -> this")
    public ParticleEffectBuilder<T> distance(Vector3f distance) {
        this.distance.set(distance.x(), distance.y(), distance.z());
        return this;
    }

    @Contract(value="_, _, _ -> this")
    public ParticleEffectBuilder<T> distance(float x, float y, float z) {
        this.distance.set(x, y, z);
        return this;
    }

    @Contract(value="_ -> this")
    public ParticleEffectBuilder<T> xDistance(float x) {
        this.distance.set(x, this.distance.y(), this.distance.z());
        return this;
    }

    @Contract(value="_ -> this")
    public ParticleEffectBuilder<T> yDistance(float y) {
        this.distance.set(this.distance.x(), y, this.distance.z());
        return this;
    }

    @Contract(value="_ -> this")
    public ParticleEffectBuilder<T> zDistance(float z) {
        this.distance.set(this.distance.x(), this.distance.y(), z);
        return this;
    }

    @Contract(value="_ -> this")
    public ParticleEffectBuilder<T> horizDistance(float distance) {
        return this.xDistance(distance).zDistance(distance);
    }

    @Contract(value="_ -> this")
    public ParticleEffectBuilder<T> distance(float distance) {
        this.distance.set(distance, distance, distance);
        return this;
    }

    public void send() {
        if (this.level == null) {
            throw new IllegalStateException("No level set");
        }
        if (this.position == null) {
            throw new IllegalStateException("No position set");
        }
        this.level.sendParticles(this.particleOptions, this.position.x, this.position.y, this.position.z, this.count, (double)this.distance.x(), (double)this.distance.y(), (double)this.distance.z(), (double)this.maxSpeed);
    }

    public ParticleEffectBuilder(@NotNull T particleOptions) {
        if (particleOptions == null) {
            throw new NullPointerException("particleOptions is marked non-null but is null");
        }
        this.particleOptions = particleOptions;
    }

    @NotNull
    public T particleOptions() {
        return this.particleOptions;
    }

    @Nullable
    public ServerLevel level() {
        return this.level;
    }

    @Nullable
    public Vector3d position() {
        return this.position;
    }

    @NotNull
    public Vector3f distance() {
        return this.distance;
    }

    public float maxSpeed() {
        return this.maxSpeed;
    }

    public int count() {
        return this.count;
    }

    public ParticleEffectBuilder<T> level(@Nullable ServerLevel level) {
        this.level = level;
        return this;
    }

    public ParticleEffectBuilder<T> maxSpeed(float maxSpeed) {
        this.maxSpeed = maxSpeed;
        return this;
    }

    public ParticleEffectBuilder<T> count(int count) {
        this.count = count;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParticleEffectBuilder)) {
            return false;
        }
        ParticleEffectBuilder other = (ParticleEffectBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.maxSpeed(), other.maxSpeed()) != 0) {
            return false;
        }
        if (this.count() != other.count()) {
            return false;
        }
        T this$particleOptions = this.particleOptions();
        T other$particleOptions = other.particleOptions();
        if (this$particleOptions == null ? other$particleOptions != null : !this$particleOptions.equals(other$particleOptions)) {
            return false;
        }
        ServerLevel this$level = this.level();
        ServerLevel other$level = other.level();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        Vector3d this$position = this.position();
        Vector3d other$position = other.position();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        Vector3f this$distance = this.distance();
        Vector3f other$distance = other.distance();
        return !(this$distance == null ? other$distance != null : !this$distance.equals(other$distance));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParticleEffectBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.maxSpeed());
        result = result * 59 + this.count();
        T $particleOptions = this.particleOptions();
        result = result * 59 + ($particleOptions == null ? 43 : $particleOptions.hashCode());
        ServerLevel $level = this.level();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        Vector3d $position = this.position();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        Vector3f $distance = this.distance();
        result = result * 59 + ($distance == null ? 43 : $distance.hashCode());
        return result;
    }

    public String toString() {
        return "ParticleEffectBuilder(particleOptions=" + String.valueOf(this.particleOptions()) + ", level=" + String.valueOf(this.level()) + ", position=" + String.valueOf(this.position()) + ", distance=" + String.valueOf(this.distance()) + ", maxSpeed=" + this.maxSpeed() + ", count=" + this.count() + ")";
    }
}

