/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.Global;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerPlayer;

@Global
public class TickFreezeCommand
extends ModdedCommand
implements CCTimedEffect {
    private final String effectName = "tick_freeze";
    private final String effectGroup = "tick_rate";
    private final List<String> effectGroups = Collections.singletonList("tick_rate");
    private final boolean exclusive = true;

    public TickFreezeCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            playerSupplier.get();
            this.onResume(request, ccPlayer);
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    private void set(boolean value) {
        this.plugin.theGame().tickRateManager().setFrozen(value);
    }

    @Override
    public void onPause(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        this.set(false);
    }

    @Override
    public void onResume(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        this.set(true);
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        this.onPause(request, source);
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }
}

