/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.qixils.crowdcontrol.common.components.MovementStatusType;
import dev.qixils.crowdcontrol.common.components.MovementStatusValue;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.event.Jump;
import dev.qixils.crowdcontrol.plugin.fabric.interfaces.MovementStatus;
import dev.qixils.crowdcontrol.plugin.fabric.mixin.LivingEntityMixin;
import dev.qixils.crowdcontrol.plugin.fabric.packets.MovementStatusS2C;
import dev.qixils.crowdcontrol.plugin.fabric.utils.EntityUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.EnumMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntityMixin
implements MovementStatus {
    @Unique
    @NotNull
    private final EnumMap<MovementStatusType, MovementStatusValue> cc$prohibited = new EnumMap(MovementStatusType.class);

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @NotNull
    public MovementStatusValue cc$getMovementStatus(@NotNull MovementStatusType type) {
        return this.cc$prohibited.getOrDefault(type, MovementStatusValue.ALLOWED);
    }

    @Override
    public void cc$setMovementStatus(@NotNull MovementStatusType type, @NotNull MovementStatusValue value) {
        if (value == MovementStatusValue.ALLOWED) {
            this.cc$prohibited.remove(type);
        } else {
            this.cc$prohibited.put(type, value);
        }
        PlayerMixin playerMixin = this;
        if (playerMixin instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerMixin;
            ModdedCrowdControlPlugin.sendToPlayerStatic(serverPlayer, new MovementStatusS2C(type, value));
        }
    }

    @Override
    public void jumpFromGround(CallbackInfo ci) {
        boolean cantWalk;
        Jump event = new Jump((Player)this, this.level().isClientSide);
        boolean cantJump = this.cc$getMovementStatus(MovementStatusType.JUMP) == MovementStatusValue.DENIED;
        boolean bl = cantWalk = this.cc$getMovementStatus(MovementStatusType.WALK) == MovementStatusValue.DENIED;
        if (cantJump || cantWalk) {
            PlayerMixin playerMixin;
            event.cancel();
            if (!event.isClientSide() && (playerMixin = this) instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)playerMixin;
                if (!cantWalk) {
                    sPlayer.connection.teleport(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
                }
            }
        }
        event.fire();
        if (event.cancelled()) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"dropEquipment(Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/GameRules;getBoolean(Lnet/minecraft/world/level/GameRules$Key;)Z")})
    private boolean equipmentKeepInventoryRedirect(GameRules gameRules, GameRules.Key<GameRules.BooleanValue> key, Operation<Boolean> original) {
        return EntityUtil.keepInventoryRedirect(this, (Boolean)original.call(new Object[]{gameRules, key}), key);
    }

    @WrapOperation(method={"getBaseExperienceReward(Lnet/minecraft/server/level/ServerLevel;)I"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/GameRules;getBoolean(Lnet/minecraft/world/level/GameRules$Key;)Z")})
    private boolean experienceKeepInventoryRedirect(GameRules gameRules, GameRules.Key<GameRules.BooleanValue> key, Operation<Boolean> original) {
        return EntityUtil.keepInventoryRedirect(this, (Boolean)original.call(new Object[]{gameRules, key}), key);
    }
}

