/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.utils;

import dev.qixils.crowdcontrol.common.util.AbstractBlockFinder;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;

public final class BlockFinder
extends AbstractBlockFinder<Location, BlockPos, ServerLevel> {
    public static final Predicate<Location> SPAWNING_SPACE = location -> BlockFinder.isPassable(location) && BlockFinder.isPassable(location.add(0.0, 1.0, 0.0).block()) && BlockFinder.isSolid(location.add(0.0, -1.0, 0.0).block());

    public static boolean isPassable(BlockState block) {
        return !block.blocksMotion();
    }

    public static boolean isPassable(Location location) {
        return BlockFinder.isPassable(location.block());
    }

    public static boolean isSolid(BlockState block) {
        return block.isSolid();
    }

    public static boolean isSolid(Location location) {
        return BlockFinder.isSolid(location.block());
    }

    public static boolean isReplaceable(BlockState block) {
        return block.canBeReplaced();
    }

    public static boolean isReplaceable(Location location) {
        return BlockFinder.isReplaceable(location.block());
    }

    private BlockFinder(ServerLevel origin, List<BlockPos> positions, Predicate<Location> locationValidator) {
        super(origin, positions, locationValidator);
    }

    public static BlockFinderBuilder builder() {
        return new BlockFinderBuilder();
    }

    @Override
    protected Location getLocation(BlockPos position) {
        return new Location((ServerLevel)this.origin, position);
    }

    public static final class BlockFinderBuilder
    extends AbstractBlockFinder.AbstractBlockFinderBuilder<BlockFinderBuilder, BlockFinder, Location, BlockPos, ServerLevel> {
        @Override
        @NotNull
        public BlockFinderBuilder origin(Location origin) {
            if (origin == null) {
                return this;
            }
            return (BlockFinderBuilder)((BlockFinderBuilder)this.originPos(origin.pos())).originWorld(origin.level());
        }

        @Override
        @NotNull
        public BlockFinderBuilder origin(Entity entity) {
            if (entity == null) {
                return this;
            }
            return this.origin(new Location(entity));
        }

        @Override
        protected int getFloorX(@NotNull BlockPos pos) {
            return pos.getX();
        }

        @Override
        protected int getFloorY(@NotNull BlockPos pos) {
            return pos.getY();
        }

        @Override
        protected int getFloorZ(@NotNull BlockPos pos) {
            return pos.getZ();
        }

        @Override
        @NotNull
        protected BlockPos createVector(int x, int y, int z) {
            return new BlockPos(x, y, z);
        }

        public BlockFinder build() {
            List<BlockPos> positions = this.preBuildDataInit();
            return new BlockFinder((ServerLevel)this.originWorld, positions, this.locationValidator);
        }
    }
}

