/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j;

import com.fasterxml.jackson.core.type.TypeReference;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.ActiveEffect;
import live.crowdcontrol.cc4j.CCEffect;
import live.crowdcontrol.cc4j.CCEventType;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.util.HttpUtil;
import live.crowdcontrol.cc4j.websocket.ConnectedPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.http.GamePack;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdControl {
    public static final int QUEUE_DURATION = 60;
    @NotNull
    private static final Logger log = LoggerFactory.getLogger((String)"CrowdControl/Manager");
    @NotNull
    protected final Map<String, Supplier<CCEffect>> effects = new HashMap<String, Supplier<CCEffect>>();
    @NotNull
    protected final Map<UUID, ConnectedPlayer> players = new HashMap<UUID, ConnectedPlayer>();
    @NotNull
    final Map<UUID, ActiveEffect> pendingRequests = new HashMap<UUID, ActiveEffect>();
    @NotNull
    final Map<UUID, ActiveEffect> timedRequests = new HashMap<UUID, ActiveEffect>();
    @NotNull
    protected final ExecutorService effectPool = Executors.newCachedThreadPool();
    @NotNull
    protected final ScheduledExecutorService timedEffectPool = Executors.newScheduledThreadPool(20);
    @NotNull
    protected final ExecutorService eventPool = Executors.newCachedThreadPool();
    @NotNull
    protected final HttpUtil httpUtil = new HttpUtil(this);
    @NotNull
    protected final String gameID;
    @NotNull
    protected final String gamePackID;
    @NotNull
    protected final String appID;
    @NotNull
    protected final String appSecret;
    @NotNull
    protected final Path dataFolder;
    @Nullable
    protected GamePack gamePack;

    public CrowdControl(@NotNull String gameID, @NotNull String gamePackID, @NotNull String appID, @NotNull String appSecret, @NotNull Path dataFolder) {
        this.gameID = gameID;
        this.gamePackID = gamePackID;
        this.appID = appID;
        this.appSecret = appSecret;
        this.dataFolder = dataFolder;
        if (!Files.exists(dataFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(dataFolder, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create data folder", e);
            }
        }
        this.loadGamePack();
    }

    @NotNull
    public String getGameID() {
        return this.gameID;
    }

    @NotNull
    public String getGamePackID() {
        return this.gamePackID;
    }

    @NotNull
    public String getAppID() {
        return this.appID;
    }

    @NotNull
    public String getAppSecret() {
        return this.appSecret;
    }

    @NotNull
    public Path getDataFolder() {
        return this.dataFolder;
    }

    @NotNull
    public ExecutorService getEffectPool() {
        return this.effectPool;
    }

    @NotNull
    public ScheduledExecutorService getTimedEffectPool() {
        return this.timedEffectPool;
    }

    @NotNull
    public ExecutorService getEventPool() {
        return this.eventPool;
    }

    @NotNull
    public HttpUtil getHttpUtil() {
        return this.httpUtil;
    }

    @Nullable
    public GamePack getGamePack() {
        return this.gamePack;
    }

    public void loadGamePack() {
        String url = String.format("/games/%s/packs", this.gameID);
        this.httpUtil.apiGet(url, new TypeReference<List<GamePack>>(this){}, null).handleAsync((gamePacks, e) -> {
            if (gamePacks == null) {
                return null;
            }
            for (GamePack gamePack : gamePacks) {
                if (!gamePack.getGamePackId().equalsIgnoreCase(this.gamePackID)) continue;
                this.gamePack = gamePack;
                return null;
            }
            return null;
        }, (Executor)this.effectPool);
    }

    @Nullable
    public CCPlayer getPlayer(@NotNull UUID playerId) {
        return this.players.get(playerId);
    }

    @NotNull
    public CCPlayer addPlayer(@NotNull UUID playerId) {
        CCPlayer existing = this.getPlayer(playerId);
        if (existing != null) {
            log.warn("Asked to add player {} with existing connection", (Object)playerId);
            return existing;
        }
        ConnectedPlayer player = new ConnectedPlayer(playerId, this);
        player.getEventManager().registerEventConsumer(CCEventType.EFFECT_RESPONSE, response -> this.handleEffectResponse((CCEffectResponse)response, player));
        player.connect();
        this.players.put(playerId, player);
        return player;
    }

    public boolean removePlayer(@NotNull UUID playerId) {
        ConnectedPlayer existing = this.players.remove(playerId);
        if (existing == null) {
            return false;
        }
        existing.stopSession();
        existing.close();
        return true;
    }

    @NotNull
    public List<CCPlayer> getPlayers() {
        return new ArrayList<CCPlayer>(this.players.values());
    }

    @NotNull
    public Set<UUID> getPlayerIds(@NotNull String ccUID) {
        return this.getPlayers().stream().filter(player -> player.getUserToken() != null && player.getUserToken().getId().equalsIgnoreCase(ccUID)).map(CCPlayer::getUuid).collect(Collectors.toSet());
    }

    public boolean addEffect(@NotNull String effectID, @NotNull CCEffect effect) {
        return this.addEffect(effectID, () -> effect);
    }

    public boolean addEffect(@NotNull String effectID, @NotNull @NotNull Supplier<@NotNull CCEffect> supplier) {
        if (!effectID.matches("^(?!__cc)[a-zA-Z_][a-zA-Z0-9_]*$")) {
            log.warn("Effect ID {} should match pattern {}", (Object)effectID, (Object)"^(?!__cc)[a-zA-Z_][a-zA-Z0-9_]*$");
        }
        if (this.effects.containsKey(effectID)) {
            log.error("Effect ID {} is already registered", (Object)effectID);
            return false;
        }
        this.effects.put(effectID, supplier);
        return true;
    }

    public void executeEffect(@NotNull PublicEffectPayload payload, @NotNull ConnectedPlayer source) {
        CCEffect ccEffect;
        String effectID = payload.getEffect().getEffectId();
        Supplier<CCEffect> supplier = this.effects.get(effectID);
        if (supplier == null) {
            log.error("Cannot execute unknown effect {}", (Object)effectID);
            source.sendResponse(new CCInstantEffectResponse(payload.getRequestId(), ResponseStatus.FAIL_PERMANENT, "Unknown Effect"));
            return;
        }
        try {
            ccEffect = supplier.get();
        }
        catch (Exception e2) {
            log.error("Failed to load effect {}", (Object)effectID, (Object)e2);
            source.sendResponse(new CCInstantEffectResponse(payload.getRequestId(), ResponseStatus.FAIL_PERMANENT, "Effect could not be loaded"));
            return;
        }
        ActiveEffect effect = new ActiveEffect(this, ccEffect, payload, source);
        this.pendingRequests.put(payload.getRequestId(), effect);
        CompletableFuture<Void> responseFuture = new CompletableFuture<Void>();
        effect.setResponseFuture(responseFuture);
        Future<?> responseThread = this.effectPool.submit(() -> {
            try {
                ccEffect.onTrigger(payload, source);
                responseFuture.complete(null);
            }
            catch (Exception e) {
                if (Thread.interrupted()) {
                    log.warn("Effect {} cancelled", (Object)effectID);
                    responseFuture.complete(null);
                    return;
                }
                log.error("Failed to invoke effect {}", (Object)effectID, (Object)e);
                source.sendResponse(new CCInstantEffectResponse(payload.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Effect experienced an unknown error"));
                responseFuture.completeExceptionally(e);
            }
        });
        effect.setResponseThread(responseThread);
        ScheduledFuture<?> responseTimeout = this.timedEffectPool.schedule(() -> this.cancel(effect, "Timed out"), 60L, TimeUnit.SECONDS);
        effect.setResponseTimeout(responseTimeout);
        responseFuture.handleAsync((result, e) -> {
            if (e != null) {
                log.error("Failed to await effect {}", (Object)effectID, e);
            }
            return null;
        }, (Executor)this.effectPool);
    }

    protected void handleEffectResponse(@NotNull CCEffectResponse response, @NotNull ConnectedPlayer source) {
        if (response.getStatus() == ResponseStatus.TIMED_END) {
            this.timedRequests.remove(response.getRequestId());
            return;
        }
        if (!response.getStatus().isTerminating()) {
            return;
        }
        ActiveEffect effect = this.pendingRequests.remove(response.getRequestId());
        if (effect == null) {
            return;
        }
        ScheduledFuture<?> responseTimeout = effect.getResponseTimeout();
        if (responseTimeout != null) {
            responseTimeout.cancel(false);
        }
        if (response.getStatus() != ResponseStatus.TIMED_BEGIN) {
            return;
        }
        source.sendResponse(new CCInstantEffectResponse(response.getRequestId(), ResponseStatus.SUCCESS, response.getMessage()));
        if (!(response instanceof CCTimedEffectResponse)) {
            return;
        }
        CCTimedEffectResponse timedResponse = (CCTimedEffectResponse)response;
        this.timedRequests.put(response.getRequestId(), effect);
        effect.scheduleCompleter(timedResponse.getTimeRemaining());
    }

    private void cancel(ActiveEffect effect, String message) {
        ScheduledFuture<?> responseTimeout;
        Future<?> responseThread;
        this.pendingRequests.remove(effect.getPayload().getRequestId());
        if (effect.isTimed()) {
            effect.complete();
        } else {
            effect.getPlayer().sendResponse(new CCInstantEffectResponse(effect.getPayload().getRequestId(), ResponseStatus.FAIL_TEMPORARY, message));
        }
        CompletableFuture<Void> responseFuture = effect.getResponseFuture();
        if (responseFuture != null) {
            responseFuture.complete(null);
        }
        if ((responseThread = effect.getResponseThread()) != null) {
            responseThread.cancel(true);
        }
        if ((responseTimeout = effect.getResponseTimeout()) != null) {
            responseTimeout.cancel(false);
        }
    }

    public void cancelByRequestId(@NotNull UUID requestId) {
        ActiveEffect effect = this.pendingRequests.remove(requestId);
        if (effect != null) {
            this.cancel(effect, "Effect cancelled before execution");
        }
        if ((effect = this.timedRequests.get(requestId)) != null) {
            this.cancel(effect, "Effect cancelled during execution");
        }
    }

    public void cancelAll() {
        HashSet<UUID> keys = new HashSet<UUID>(this.pendingRequests.keySet());
        for (UUID key : keys) {
            this.cancel(this.pendingRequests.get(key), "Effect cancelled before execution");
        }
        keys = new HashSet<UUID>(this.timedRequests.keySet());
        for (UUID key : keys) {
            this.cancel(this.timedRequests.get(key), "Effect cancelled during execution");
        }
    }

    public void pauseByRequestId(@NotNull UUID requestId) {
        ActiveEffect effect = this.pendingRequests.remove(requestId);
        if (effect != null) {
            this.cancel(effect, "Effect paused before execution");
            return;
        }
        effect = this.timedRequests.get(requestId);
        if (effect == null) {
            return;
        }
        effect.pause();
    }

    public void pauseAll() {
        new ArrayList<ActiveEffect>(this.pendingRequests.values()).forEach(effect -> this.cancel((ActiveEffect)effect, "All pending effects were requested to be stopped"));
        this.timedRequests.values().forEach(ActiveEffect::pause);
    }

    public void resumeByRequestId(@NotNull UUID requestId) {
        ActiveEffect effect = this.timedRequests.get(requestId);
        if (effect == null) {
            return;
        }
        effect.resume();
    }

    public void resumeAll() {
        this.timedRequests.values().forEach(ActiveEffect::resume);
    }

    public boolean isPlayerEffectActive(@NotNull String effectId, @NotNull UUID playerId) {
        return this.timedRequests.values().stream().anyMatch(effect -> effect.getPlayer().getUuid().equals(playerId) && effect.getPayload().getEffect().getEffectId().equals(effectId));
    }

    public void close() {
        this.cancelAll();
        HashSet<UUID> uuids = new HashSet<UUID>(this.players.keySet());
        for (UUID uuid : uuids) {
            this.removePlayer(uuid);
        }
        this.effectPool.shutdown();
        this.timedEffectPool.shutdown();
        this.eventPool.shutdown();
    }
}

