/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.minecraft.extras.caption;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import org.apiguardian.api.API;
import org.incendo.cloud.caption.Caption;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.minecraft.extras.caption.ComponentCaptionFormatter;
import org.incendo.cloud.minecraft.extras.caption.RichVariable;

@API(status=API.Status.INTERNAL)
final class PatternReplacingComponentCaptionFormatter<C>
implements ComponentCaptionFormatter<C> {
    private final Pattern pattern;

    PatternReplacingComponentCaptionFormatter(@NonNull Pattern pattern) {
        this.pattern = pattern;
    }

    public @NonNull Component formatCaption(@NonNull Caption captionKey, @NonNull C recipient, @NonNull String caption, @NonNull List<@NonNull CaptionVariable> variables) {
        HashMap<String, Object> replacements = new HashMap<String, Object>();
        for (CaptionVariable variable : variables) {
            if (variable instanceof RichVariable) {
                replacements.put(variable.key(), ((RichVariable)variable).component());
                continue;
            }
            replacements.put(variable.key(), Component.text((String)variable.value()));
        }
        TextReplacementConfig replacementConfig = (TextReplacementConfig)TextReplacementConfig.builder().match(this.pattern).replacement((matcher, builder) -> (ComponentLike)replacements.getOrDefault(matcher.group(1), Component.text((String)matcher.group()))).build();
        return Component.text((String)caption).replaceText(replacementConfig);
    }
}

