/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.api.logistics.board;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockItem;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.registry.PanelType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import org.jetbrains.annotations.NotNull;

public class PanelBlockItem
extends LogisticallyLinkedBlockItem {
    private final Supplier<PanelType<?>> type;

    public PanelBlockItem(Supplier<PanelType<?>> type, Item.Properties properties) {
        super((Block)AllBlocks.FACTORY_GAUGE.get(), properties);
        this.type = type;
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return stack.isEnchanted();
    }

    @NotNull
    public InteractionResult place(BlockPlaceContext context) {
        Player player = context.getPlayer();
        Component error = this.isReadyForPlacement(context.getItemInHand(), context.getLevel(), context.getClickedPos(), player);
        if (error == null) {
            return super.place(context);
        }
        AllSoundEvents.DENY.playOnServer(context.getLevel(), (Vec3i)context.getClickedPos());
        if (player != null) {
            player.displayClientMessage(error, true);
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        InteractionResult interactionResult = this.place(new BlockPlaceContext(context));
        Player player = context.getPlayer();
        if (!interactionResult.consumesAction() && context.getItemInHand().has(DataComponents.FOOD) && player != null) {
            InteractionResult result = super.use(context.getLevel(), player, context.getHand()).getResult();
            return result == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : result;
        }
        return interactionResult;
    }

    protected AbstractPanelBehaviour getNewBehaviourInstance(FactoryPanelBlockEntity blockEntity, FactoryPanelBlock.PanelSlot slot) {
        return this.type.get().create(blockEntity, slot);
    }

    public void applyExtraPlacementData(BlockPlaceContext context, FactoryPanelBlockEntity blockEntity, FactoryPanelBlock.PanelSlot targetedSlot) {
        ItemStack stack = context.getItemInHand();
        this.applyToSlot(blockEntity, targetedSlot, LogisticallyLinkedBlockItem.networkFromStack((ItemStack)FactoryPanelBlockItem.fixCtrlCopiedStack((ItemStack)stack)));
        Component message = this.getPlacedMessage();
        Player player = context.getPlayer();
        if (player == null) {
            return;
        }
        if (!context.getPlayer().isCreative()) {
            stack.shrink(1);
            if (stack.isEmpty()) {
                player.setItemInHand(context.getHand(), ItemStack.EMPTY);
            }
        }
        player.displayClientMessage(message, true);
    }

    public boolean applyToSlot(FactoryPanelBlockEntity blockEntity, FactoryPanelBlock.PanelSlot slot, @Nullable UUID networkId) {
        FactoryPanelBehaviour oldBehaviour = (FactoryPanelBehaviour)blockEntity.panels.get(slot);
        if (oldBehaviour == null || !oldBehaviour.isActive()) {
            AbstractPanelBehaviour newBehaviour = this.getNewBehaviourInstance(blockEntity, slot);
            newBehaviour.active = true;
            if (networkId != null) {
                newBehaviour.setNetwork(networkId);
            }
            blockEntity.attachBehaviourLate((BlockEntityBehaviour)newBehaviour);
            blockEntity.panels.put(slot, newBehaviour);
            blockEntity.redraw = true;
            blockEntity.lastShape = null;
            blockEntity.notifyUpdate();
            if (blockEntity.activePanels() > 1) {
                SoundType soundType = blockEntity.getBlockState().getSoundType();
                blockEntity.getLevel().playSound(null, blockEntity.getBlockPos(), soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public Component isReadyForPlacement(ItemStack stack, Level level, BlockPos pos, @Nullable Player player) {
        return null;
    }

    @NotNull
    public Component getPlacedMessage() {
        return Component.empty();
    }

    public void registerBlocks(@NotNull Map<Block, Item> blockToItemMap, @NotNull Item item) {
    }

    @NotNull
    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }
}

