/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics.board;

import net.createmod.catnip.platform.CatnipServices;
import net.liukrast.eg.ExtraGauges;
import net.liukrast.eg.api.logistics.board.BasicPanelScreen;
import net.liukrast.eg.content.logistics.board.StringPanelBehaviour;
import net.liukrast.eg.networking.StringPanelUpdatePacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class StringPanelScreen
extends BasicPanelScreen<StringPanelBehaviour> {
    public static final ResourceLocation TEXTURE = ExtraGauges.id("textures/gui/string_gauge.png", new Object[0]);
    private EditBox joinBox;
    private EditBox regexBox;
    private EditBox replaceBox;

    public StringPanelScreen(StringPanelBehaviour behaviour) {
        super(behaviour);
    }

    @Override
    protected void init() {
        super.init();
        int x = this.guiLeft;
        int y = this.guiTop;
        String joinText = this.joinBox == null ? ((StringPanelBehaviour)this.behaviour).getJoin() : this.joinBox.getValue();
        this.joinBox = new EditBox(this.font, x + 32, y + 40, 130, 20, (Component)Component.empty());
        if (joinText != null) {
            this.joinBox.setValue(joinText);
        }
        this.joinBox.setMaxLength(100);
        this.joinBox.setTextColor(-11250604);
        this.joinBox.setTextShadow(false);
        this.joinBox.setBordered(false);
        this.addRenderableWidget((GuiEventListener)this.joinBox);
        String regexText = this.regexBox == null ? ((StringPanelBehaviour)this.behaviour).getRegex() : this.regexBox.getValue();
        this.regexBox = new EditBox(this.font, x + 32, y + 40 + 34, 130, 20, (Component)Component.empty());
        if (regexText != null) {
            this.regexBox.setValue(regexText);
        }
        this.regexBox.setMaxLength(100);
        this.regexBox.setTextColor(-11250604);
        this.regexBox.setTextShadow(false);
        this.regexBox.setBordered(false);
        this.addRenderableWidget((GuiEventListener)this.regexBox);
        String replaceText = this.replaceBox == null ? ((StringPanelBehaviour)this.behaviour).getReplacement() : this.replaceBox.getValue();
        this.replaceBox = new EditBox(this.font, x + 32, y + 40 + 34 + 34, 130, 30, (Component)Component.empty());
        if (replaceText != null) {
            this.replaceBox.setValue(replaceText);
        }
        this.replaceBox.setMaxLength(100);
        this.replaceBox.setTextColor(-11250604);
        this.replaceBox.setTextShadow(false);
        this.replaceBox.setBordered(false);
        this.addRenderableWidget((GuiEventListener)this.replaceBox);
    }

    @Override
    public int getWindowWidth() {
        return 80;
    }

    @Override
    public int getWindowHeight() {
        return 120;
    }

    @Override
    public void onConfirm() {
        StringPanelUpdatePacket packet = new StringPanelUpdatePacket(((StringPanelBehaviour)this.behaviour).getPanelPosition(), this.joinBox.getValue(), this.regexBox.getValue(), this.replaceBox.getValue());
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)packet);
        super.onConfirm();
    }

    @Override
    protected void renderWindow(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        graphics.drawString(this.font, (Component)Component.literal((String)"Join:"), this.guiLeft + 20, this.guiTop + 24, -12309720, false);
        graphics.blit(TEXTURE, this.guiLeft + 8, this.guiTop + 30, 0, 0, 160, 32);
        graphics.drawString(this.font, (Component)Component.literal((String)"Regex:"), this.guiLeft + 20, this.guiTop + 24 + 34, -12309720, false);
        graphics.blit(TEXTURE, this.guiLeft + 8, this.guiTop + 30 + 34, 0, 0, 160, 32);
        graphics.drawString(this.font, (Component)Component.literal((String)"Replacement:"), this.guiLeft + 20, this.guiTop + 24 + 34 + 34, -12309720, false);
        graphics.blit(TEXTURE, this.guiLeft + 8, this.guiTop + 30 + 34 + 34, 0, 0, 160, 32);
    }
}

