/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg;

import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.liukrast.eg.ExtraGaugesConfig;
import net.liukrast.eg.ExtraGaugesPonderPlugin;
import net.liukrast.eg.api.EGRegistries;
import net.liukrast.eg.datagen.ExtraGaugesBlockModelProvider;
import net.liukrast.eg.datagen.ExtraGaugesBlockStateProvider;
import net.liukrast.eg.datagen.ExtraGaugesItemModelProvider;
import net.liukrast.eg.registry.EGBlockEntityTypes;
import net.liukrast.eg.registry.EGBlocks;
import net.liukrast.eg.registry.EGCreativeModeTabs;
import net.liukrast.eg.registry.EGDisplayTargets;
import net.liukrast.eg.registry.EGExtraPanelConnections;
import net.liukrast.eg.registry.EGItems;
import net.liukrast.eg.registry.EGPanelConnections;
import net.liukrast.eg.registry.EGPanels;
import net.liukrast.eg.registry.EGPartialModels;
import net.liukrast.eg.registry.RegisterPackets;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="extra_gauges")
public class ExtraGauges {
    public static final String MOD_ID = "extra_gauges";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"extra_gauges");

    public static ResourceLocation id(String path, Object ... args) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)String.format(path, args));
    }

    public ExtraGauges(IEventBus modEventBus, ModContainer modContainer) {
        EGItems.register(modEventBus);
        EGPanels.register(modEventBus);
        EGCreativeModeTabs.register(modEventBus);
        EGPanelConnections.register(modEventBus);
        EGBlocks.register(modEventBus);
        EGBlockEntityTypes.register(modEventBus);
        EGDisplayTargets.register(modEventBus);
        modEventBus.register((Object)this);
        modEventBus.addListener(EGBlockEntityTypes::registerRenderers);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ExtraGaugesConfig.SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ExtraGaugesConfig.CLIENT_SPEC);
        RegisterPackets.register();
        NeoForge.EVENT_BUS.addListener(this::loadLevel);
    }

    private void loadLevel(LevelEvent.Load event) {
        EGExtraPanelConnections.register();
        EGPanelConnections.initDefaults();
    }

    @SubscribeEvent
    private void fMLClientSetup(FMLClientSetupEvent event) {
        EGPartialModels.init();
        PonderIndex.addPlugin((PonderPlugin)new ExtraGaugesPonderPlugin());
    }

    @SubscribeEvent
    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new ExtraGaugesItemModelProvider(packOutput, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ExtraGaugesBlockModelProvider(packOutput, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ExtraGaugesBlockStateProvider(packOutput, helper));
    }

    @SubscribeEvent
    private void newRegistry(NewRegistryEvent event) {
        event.register(EGRegistries.PANEL_REGISTRY);
        event.register(EGRegistries.PANEL_CONNECTION_REGISTRY);
    }
}

