/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics;

import com.mojang.serialization.DynamicOps;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Iterator;
import java.util.List;
import net.liukrast.eg.ExtraGauges;
import net.liukrast.eg.api.logistics.ColoredFactoryPanelSupportBehaviour;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnection;
import net.liukrast.eg.registry.EGBlockEntityTypes;
import net.liukrast.eg.registry.EGPanelConnections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class DisplayCollectorBlockEntity
extends DisplayLinkBlockEntity {
    private Component component;

    public DisplayCollectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EGBlockEntityTypes.DISPLAY_COLLECTOR.get(), pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.factoryPanelSupport = new ColoredFactoryPanelSupportBehaviour(be -> {
            AbstractPanelBehaviour ab;
            boolean bool = !(be instanceof AbstractPanelBehaviour) || (ab = (AbstractPanelBehaviour)((Object)be)).hasConnection((PanelConnection)EGPanelConnections.STRING.get());
            return new ColoredFactoryPanelSupportBehaviour.Line(bool ? -1 : 0x888898, true);
        }, (SmartBlockEntity)this, () -> true, () -> false, () -> {});
        behaviours.add((BlockEntityBehaviour)this.factoryPanelSupport);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        if (!tag.contains("text")) {
            return;
        }
        RegistryOps dynamicops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ComponentSerialization.FLAT_CODEC.parse((DynamicOps)dynamicops, (Object)tag.get("text")).resultOrPartial(arg_0 -> ((Logger)ExtraGauges.LOGGER).error(arg_0)).ifPresent(text -> {
            this.component = text;
        });
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (this.component == null) {
            return;
        }
        RegistryOps dynamicops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ComponentSerialization.FLAT_CODEC.encodeStart((DynamicOps)dynamicops, (Object)this.component).resultOrPartial(arg_0 -> ((Logger)ExtraGauges.LOGGER).error(arg_0)).ifPresent(tag1 -> tag.put("text", tag1));
    }

    public Component getComponent() {
        return this.component == null ? Component.empty() : this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.factoryPanelSupport.notifyPanels();
    }

    public BlockPos getSourcePosition() {
        return this.worldPosition.offset((Vec3i)this.targetOffset);
    }

    public BlockPos getTargetPosition() {
        Iterator iterator = this.factoryPanelSupport.getLinkedPanels().iterator();
        if (iterator.hasNext()) {
            FactoryPanelPosition position = (FactoryPanelPosition)iterator.next();
            return position.pos();
        }
        return this.worldPosition.relative(this.getDirection());
    }
}

