/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.foundation.block.IBE;
import net.liukrast.eg.content.logistics.IntSelectorBlockEntity;
import net.liukrast.eg.registry.EGBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class IntSelectorBlock
extends FaceAttachedHorizontalDirectionalBlock
implements IBE<IntSelectorBlockEntity> {
    public static final MapCodec<IntSelectorBlock> CODEC = IntSelectorBlock.simpleCodec(IntSelectorBlock::new);

    public IntSelectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)worldIn, (BlockPos)pos, (BlockState)newState);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        boolean x1 = dir.getAxis() == Direction.Axis.X;
        boolean x = dir == Direction.EAST;
        boolean z1 = dir.getAxis() == Direction.Axis.Z;
        boolean z = dir == Direction.SOUTH;
        return switch ((AttachFace)state.getValue((Property)FACE)) {
            default -> throw new MatchException(null, null);
            case AttachFace.WALL -> IntSelectorBlock.box((double)(x1 ? (x ? 0.0 : 14.0) : 4.0), (double)4.0, (double)(z1 ? (z ? 0.0 : 14.0) : 4.0), (double)(x1 ? (x ? 2.0 : 16.0) : 12.0), (double)12.0, (double)(z1 ? (z ? 2.0 : 16.0) : 12.0));
            case AttachFace.FLOOR -> IntSelectorBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
            case AttachFace.CEILING -> IntSelectorBlock.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING, FACE}));
    }

    public Class<IntSelectorBlockEntity> getBlockEntityClass() {
        return IntSelectorBlockEntity.class;
    }

    public BlockEntityType<? extends IntSelectorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)EGBlockEntityTypes.INT_SELECTOR.get();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @NotNull
    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

