/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics.board;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelScreen;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.nbt.NBTHelper;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.registry.PanelType;
import net.liukrast.eg.mixin.FactoryPanelBehaviourAccessor;
import net.liukrast.eg.registry.EGItems;
import net.liukrast.eg.registry.EGPanelConnections;
import net.liukrast.eg.registry.EGPartialModels;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PassivePanelBehaviour
extends AbstractPanelBehaviour {
    public PassivePanelBehaviour(PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super(type, be, slot);
    }

    @Override
    public void addConnections(AbstractPanelBehaviour.PanelConnectionBuilder builder) {
        builder.put(EGPanelConnections.FILTER, () -> this.filter);
    }

    @Override
    public Item getItem() {
        return (Item)EGItems.PASSIVE_GAUGE.get();
    }

    public void tick() {
        int count = 0;
        for (FactoryPanelPosition panelPos : this.targeting) {
            FactoryPanelConnection by;
            FactoryPanelBehaviour panel = PassivePanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelPosition)panelPos);
            if (panel == null || panel.satisfied || panel.promisedSatisfied || (by = (FactoryPanelConnection)panel.targetedBy.get(this.getPanelPosition())) == null) continue;
            count += by.amount;
        }
        this.count = count;
        super.tick();
    }

    @Override
    public PartialModel getModel(FactoryPanelBlock.PanelState panelState, FactoryPanelBlock.PanelType panelType) {
        return EGPartialModels.PASSIVE_PANEL;
    }

    @Override
    public boolean withFilteringBehaviour() {
        return true;
    }

    @Override
    public boolean skipOriginalTick() {
        return false;
    }

    @Override
    public void displayScreen(Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new FactoryPanelScreen((FactoryPanelBehaviour)this));
        }
    }

    @Override
    public boolean shouldRenderBulb(boolean original) {
        return original;
    }

    @Override
    public int calculatePath(FactoryPanelBehaviour other, int original) {
        return other instanceof AbstractPanelBehaviour ? EGPanelConnections.getConnectionValue(other, EGPanelConnections.REDSTONE).map(v -> v == 0 ? 5767425 : 0xEF0000).orElse(original) : original;
    }

    @Override
    public void easyWrite(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        nbt.putString("RecipeAddress", this.recipeAddress);
        nbt.putInt("RecipeOutput", this.recipeOutput);
        nbt.putInt("PromiseClearingInterval", this.promiseClearingInterval);
        nbt.putUUID("Freq", this.network);
        nbt.put("Craft", (Tag)NBTHelper.writeItemList((Iterable)this.activeCraftingArrangement, (HolderLookup.Provider)registries));
        FactoryPanelBehaviourAccessor asInterface = (FactoryPanelBehaviourAccessor)((Object)this);
        nbt.putInt("Timer", asInterface.getTimer());
        nbt.putInt("LastLevel", asInterface.getLastReportedLevelInStorage());
        nbt.putInt("LastPromised", asInterface.getLastReportedPromises());
        nbt.putInt("LastUnloadedLinks", asInterface.getLastReportedUnloadedLinks());
    }

    public ValueSettingsBehaviour.ValueSettings getValueSettings() {
        return null;
    }

    public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings settings, boolean ctrlDown) {
    }

    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        return null;
    }

    public MutableComponent getLabel() {
        String key;
        if (this.targetedBy.isEmpty()) {
            return Component.translatable((String)"extra_gauges.gui.passive_panel.no_recipe").withStyle(ChatFormatting.RED);
        }
        if (this.isMissingAddress()) {
            return CreateLang.translate((String)"gui.factory_panel.address_missing", (Object[])new Object[0]).style(ChatFormatting.RED).component();
        }
        if (this.getFilter().isEmpty()) {
            key = "factory_panel.new_factory_task";
        } else if (this.waitingForNetwork) {
            key = "factory_panel.some_links_unloaded";
        } else {
            if (this.getAmount() == 0 || this.targetedBy.isEmpty()) {
                return this.getFilter().getHoverName().plainCopy();
            }
            Object key2 = this.getFilter().getHoverName().getString();
            if (this.redstonePowered) {
                key2 = (String)key2 + " " + CreateLang.translate((String)"factory_panel.redstone_paused", (Object[])new Object[0]).string();
            } else if (!this.satisfied) {
                key2 = (String)key2 + " " + CreateLang.translate((String)"factory_panel.in_progress", (Object[])new Object[0]).string();
            }
            return CreateLang.text((String)key2).component();
        }
        return CreateLang.translate((String)key, (Object[])new Object[0]).component();
    }

    @Override
    public boolean ignoreIssue(@Nullable String issue) {
        return false;
    }
}

