/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.api.logistics.board;

import com.mojang.serialization.Codec;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.createmod.catnip.codecs.CatnipCodecUtils;
import net.createmod.catnip.codecs.CatnipCodecs;
import net.createmod.catnip.gui.ScreenOpener;
import net.liukrast.eg.api.EGRegistries;
import net.liukrast.eg.api.logistics.board.BasicPanelScreen;
import net.liukrast.eg.api.logistics.board.PanelConnection;
import net.liukrast.eg.api.registry.PanelType;
import net.liukrast.eg.api.util.ConnectionExtra;
import net.liukrast.eg.api.util.IFPExtra;
import net.liukrast.eg.mixin.FactoryPanelBehaviourIMixin;
import net.liukrast.eg.mixin.FilteringBehaviourMixin;
import net.liukrast.eg.registry.EGPanelConnections;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPanelBehaviour
extends FactoryPanelBehaviour {
    private final PanelType<?> type;
    private final Reference2ObjectArrayMap<PanelConnection<?>, Supplier<?>> connections = new Reference2ObjectArrayMap();
    protected static final int WAITING = 16766273;
    protected static final int DISABLED = 0x888898;

    public AbstractPanelBehaviour(ValueBoxTransform valueBoxTransform, PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        this(type, be, slot);
        ((FilteringBehaviourMixin)((Object)this)).setValueBoxTransform(valueBoxTransform);
    }

    public AbstractPanelBehaviour(PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super(be, slot);
        PanelConnectionBuilder builder = new PanelConnectionBuilder();
        this.addConnections(builder);
        this.connections.putAll(builder.map);
        this.type = type;
    }

    public abstract void addConnections(PanelConnectionBuilder var1);

    public Set<PanelConnection<?>> getConnections() {
        return this.connections.keySet();
    }

    public <T> boolean hasConnection(DeferredHolder<PanelConnection<?>, PanelConnection<T>> connection) {
        return this.hasConnection((PanelConnection)connection.get());
    }

    public boolean hasConnection(PanelConnection<?> connection) {
        return this.connections.containsKey(connection);
    }

    public MutableComponent getDisplayLinkComponent(boolean shortenNumbers) {
        return Component.empty();
    }

    public boolean skipOriginalTick() {
        return true;
    }

    public boolean shouldRenderBulb(boolean original) {
        return false;
    }

    public boolean withFilteringBehaviour() {
        return false;
    }

    public abstract Item getItem();

    public abstract PartialModel getModel(FactoryPanelBlock.PanelState var1, FactoryPanelBlock.PanelType var2);

    public void easyWrite(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
    }

    public void easyRead(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void displayScreen(Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open(new BasicPanelScreen<AbstractPanelBehaviour>(this));
        }
    }

    public boolean ignoreIssue(@Nullable String issue) {
        return "factory_panel.no_item".equals(issue);
    }

    public int calculatePath(FactoryPanelBehaviour other, int original) {
        return 0x888898;
    }

    public int calculateExtraPath(BlockPos pos) {
        return 0x888898;
    }

    @ApiStatus.Internal
    public <T> Optional<T> getConnectionValue(DeferredHolder<PanelConnection<?>, PanelConnection<T>> connection) {
        return this.getConnectionValue((PanelConnection)connection.get());
    }

    @ApiStatus.Internal
    public <T> Optional<T> getConnectionValue(PanelConnection<T> connection) {
        if (!this.connections.containsKey(connection)) {
            return Optional.empty();
        }
        return Optional.ofNullable(((Supplier)this.connections.get(connection)).get());
    }

    public PanelType<?> getPanelType() {
        return this.type;
    }

    public void initialize() {
        super.initialize();
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return null;
    }

    public void destroy() {
        super.destroy();
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        if (smartBlockEntity instanceof FactoryPanelBlockEntity) {
            FactoryPanelBlockEntity be = (FactoryPanelBlockEntity)smartBlockEntity;
            FactoryPanelBehaviour newBehaviour = new FactoryPanelBehaviour(be, this.slot);
            newBehaviour.active = false;
            this.blockEntity.attachBehaviourLate((BlockEntityBehaviour)newBehaviour);
            be.panels.put(this.slot, newBehaviour);
            be.redraw = true;
            be.lastShape = null;
            be.notifyUpdate();
        }
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(nbt, registries, clientPacket);
        CompoundTag panelTag = nbt.getCompound(CreateLang.asId((String)this.slot.name()));
        if (panelTag.isEmpty()) {
            this.active = false;
            return;
        }
        this.easyRead(panelTag, registries, clientPacket);
    }

    public void consumeForLinks(Consumer<FactoryPanelSupportBehaviour> consumer) {
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            if (!this.getWorld().isLoaded(connection.from.pos())) {
                return;
            }
            FactoryPanelSupportBehaviour linkAt = AbstractPanelBehaviour.linkAt((BlockAndTintGetter)this.getWorld(), (FactoryPanelConnection)connection);
            if (linkAt == null) {
                return;
            }
            if (!linkAt.isOutput()) continue;
            consumer.accept(linkAt);
        }
    }

    public <T> void consumeForPanels(PanelConnection<T> panelConnection, Consumer<T> consumer) {
        for (FactoryPanelConnection connection : this.targetedBy.values()) {
            if (!this.getWorld().isLoaded(connection.from.pos())) {
                return;
            }
            FactoryPanelBehaviour at = AbstractPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelConnection)connection);
            if (at == null) {
                return;
            }
            Optional<T> opt = EGPanelConnections.getConnectionValue(at, panelConnection);
            if (opt.isEmpty()) continue;
            consumer.accept(opt.get());
        }
    }

    public <T> void consumeForExtra(PanelConnection<T> panelConnection, BiConsumer<BlockPos, T> consumer) {
        HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
        for (FactoryPanelConnection connection : ((IFPExtra)((Object)this)).extra_gauges$getExtra().values()) {
            BlockPos pos2 = connection.from.pos();
            if (!this.getWorld().isLoaded(pos2)) {
                return;
            }
            Level level = this.getWorld();
            BlockState state = level.getBlockState(pos2);
            BlockEntity be = level.getBlockEntity(pos2);
            ConnectionExtra<T> listener = panelConnection.getListener(state.getBlock());
            if (listener == null) {
                toRemove.add(connection.from.pos());
                continue;
            }
            Optional<Object> opt = listener.invalidate(level, state, pos2, be);
            opt.ifPresent(t -> consumer.accept(pos2, t));
        }
        toRemove.forEach(pos -> ((IFPExtra)((Object)this)).extra_gauges$getExtra().remove(pos));
        if (!toRemove.isEmpty()) {
            this.blockEntity.notifyUpdate();
        }
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(nbt, registries, clientPacket);
        CompoundTag special = nbt.contains("CustomPanels") ? nbt.getCompound("CustomPanels") : new CompoundTag();
        special.putString(CreateLang.asId((String)this.slot.name()), Objects.requireNonNull(EGRegistries.PANEL_REGISTRY.getKey(this.type)).toString());
        nbt.put("CustomPanels", (Tag)special);
        if (!this.active) {
            return;
        }
        CompoundTag panelTag = new CompoundTag();
        panelTag.putBoolean("Satisfied", this.satisfied);
        panelTag.putBoolean("PromisedSatisfied", this.promisedSatisfied);
        panelTag.putBoolean("RedstonePowered", this.redstonePowered);
        panelTag.put("Targeting", (Tag)CatnipCodecUtils.encode((Codec)CatnipCodecs.set((Codec)FactoryPanelPosition.CODEC), (Object)this.targeting).orElseThrow());
        panelTag.put("TargetedBy", (Tag)CatnipCodecUtils.encode((Codec)Codec.list((Codec)FactoryPanelConnection.CODEC), new ArrayList(this.targetedBy.values())).orElseThrow());
        panelTag.put("TargetedByLinks", (Tag)CatnipCodecUtils.encode((Codec)Codec.list((Codec)FactoryPanelConnection.CODEC), new ArrayList(this.targetedByLinks.values())).orElseThrow());
        IFPExtra extra = (IFPExtra)((Object)this);
        panelTag.put("TargetedByExtra", (Tag)CatnipCodecUtils.encode((Codec)Codec.list((Codec)FactoryPanelConnection.CODEC), new ArrayList<FactoryPanelConnection>(extra.extra_gauges$getExtra().values())).orElseThrow());
        if (extra.extra_gauges$getWidth() != 3) {
            panelTag.putInt("extra_gauges$CraftWidth", extra.extra_gauges$getWidth());
        }
        if (this.withFilteringBehaviour()) {
            panelTag.put("Filter", this.getFilter().saveOptional(registries));
            panelTag.putInt("FilterAmount", this.count);
            panelTag.putBoolean("UpTo", this.upTo);
        }
        this.easyWrite(panelTag, registries, clientPacket);
        nbt.put(CreateLang.asId((String)this.slot.name()), (Tag)panelTag);
    }

    public boolean canShortInteract(ItemStack toApply) {
        return this.withFilteringBehaviour() && super.canShortInteract(toApply);
    }

    public ItemStack getFilter() {
        return this.getConnectionValue(EGPanelConnections.FILTER).orElse(FilterItemStack.empty()).item();
    }

    public void notifyRedstoneOutputs() {
        for (FactoryPanelPosition panelPos : this.targeting) {
            if (!this.getWorld().isLoaded(panelPos.pos())) {
                return;
            }
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelPosition)panelPos);
            if (behaviour == null) continue;
            behaviour.checkForRedstoneInput();
        }
        ((FactoryPanelBehaviourIMixin)((Object)this)).extra_gauges$notifyRedstoneOutputs();
    }

    public boolean acceptsValueSettings() {
        return true;
    }

    @NotNull
    public Component getDisplayName() {
        return this.getItem().getDefaultInstance().getHoverName();
    }

    public static class PanelConnectionBuilder {
        private final Map<PanelConnection<?>, Supplier<?>> map = new Reference2ObjectArrayMap();

        private PanelConnectionBuilder() {
        }

        public <T> PanelConnectionBuilder put(@NotNull DeferredHolder<PanelConnection<?>, PanelConnection<T>> panelConnection, @NotNull Supplier<T> getter) {
            return this.put((PanelConnection)panelConnection.get(), getter);
        }

        public <T> PanelConnectionBuilder put(@NotNull PanelConnection<T> panelConnection, @NotNull Supplier<T> getter) {
            this.map.put(panelConnection, getter);
            return this;
        }
    }
}

