/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics.board;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.liukrast.eg.ExtraGaugesConfig;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnection;
import net.liukrast.eg.api.registry.PanelType;
import net.liukrast.eg.content.logistics.board.NumericalScrollPanelBehaviour;
import net.liukrast.eg.registry.EGItems;
import net.liukrast.eg.registry.EGPanelConnections;
import net.liukrast.eg.registry.EGPartialModels;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.BlockHitResult;

public class CounterPanelBehaviour
extends NumericalScrollPanelBehaviour {
    private int updated;

    public CounterPanelBehaviour(PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super((Component)Component.translatable((String)"create.logistics.counter_threshold"), type, be, slot);
        this.between(0, 256);
    }

    @Override
    public boolean shouldRenderBulb(boolean original) {
        return true;
    }

    @Override
    public String formatValue() {
        if (this.value == 0) {
            return (String)this.formatter.apply(this.count);
        }
        return (String)this.formatter.apply(this.count) + "/" + (String)this.formatter.apply(this.value);
    }

    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        ImmutableList rows = ImmutableList.of((Object)Component.literal((String)"Positive").withStyle(ChatFormatting.BOLD));
        ValueSettingsFormatter formatter = new ValueSettingsFormatter(this::formatSettings);
        return new ValueSettingsBoard(this.label, 256, 32, (List)rows, formatter);
    }

    @Override
    public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlHeld) {
        int value = valueSetting.value();
        if (!valueSetting.equals((Object)this.getValueSettings())) {
            this.playFeedbackSound((BlockEntityBehaviour)this);
        }
        this.setValue(value);
    }

    @Override
    public void easyWrite(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.easyWrite(nbt, registries, clientPacket);
        nbt.putInt("Count", this.count);
    }

    @Override
    public void easyRead(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.easyRead(nbt, registries, clientPacket);
        this.count = nbt.getInt("Count");
    }

    @Override
    public int calculatePath(FactoryPanelBehaviour other, int original) {
        return EGPanelConnections.getConnectionValue(other, EGPanelConnections.REDSTONE).map(v -> v == 0 ? 0xEF0000 : 5767425).orElse(super.calculatePath(other, original));
    }

    @Override
    public void addConnections(AbstractPanelBehaviour.PanelConnectionBuilder builder) {
        builder.put(EGPanelConnections.INTEGER, () -> this.count);
        builder.put(EGPanelConnections.REDSTONE, () -> this.count >= this.value ? 15 : 0);
    }

    @Override
    public Item getItem() {
        return EGItems.COUNTER_GAUGE.asItem();
    }

    @Override
    public PartialModel getModel(FactoryPanelBlock.PanelState panelState, FactoryPanelBlock.PanelType panelType) {
        return EGPartialModels.COUNTER_PANEL;
    }

    public void tick() {
        super.tick();
        this.updated = 0;
    }

    public void checkForRedstoneInput() {
        if (!this.active || this.updated > (Integer)ExtraGaugesConfig.COUNTER_MAX_CHAIN.get()) {
            return;
        }
        AtomicBoolean shouldPower = new AtomicBoolean(false);
        this.consumeForLinks(link -> shouldPower.set(shouldPower.get() | link.shouldPanelBePowered()));
        this.consumeForPanels((PanelConnection)EGPanelConnections.REDSTONE.get(), out -> shouldPower.set(shouldPower.get() | out > 0));
        this.consumeForExtra((PanelConnection)EGPanelConnections.REDSTONE.get(), (pos, out) -> {});
        if (shouldPower.get() != this.redstonePowered) {
            return;
        }
        boolean bl = this.redstonePowered = !shouldPower.get();
        if (shouldPower.get()) {
            this.count = this.count >= this.value && this.value != 0 ? 0 : ++this.count;
        }
        this.blockEntity.notifyUpdate();
        ++this.updated;
        for (FactoryPanelPosition panelPos : this.targeting) {
            if (!this.getWorld().isLoaded(panelPos.pos())) {
                return;
            }
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelPosition)panelPos);
            if (behaviour == null) continue;
            behaviour.checkForRedstoneInput();
        }
        this.notifyRedstoneOutputs();
    }

    @Override
    public MutableComponent getDisplayLinkComponent(boolean shortened) {
        return Component.literal((String)(shortened ? String.valueOf(this.count) : this.count + "/" + this.value));
    }
}

