/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.api.logistics.board;

import java.util.HashMap;
import java.util.Map;
import net.liukrast.eg.EGConstants;
import net.liukrast.eg.api.EGRegistries;
import net.liukrast.eg.api.util.ConnectionExtra;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PanelConnection<T> {
    private final Map<Block, ConnectionExtra<T>> extraConnections = new HashMap<Block, ConnectionExtra<T>>();

    public void addListener(ConnectionExtra<T> supplier, Block ... validBlocks) {
        if (validBlocks.length == 0) {
            EGConstants.LOGGER.error("Registered panel connection listener without any blocks. {}", (Object)this);
        }
        for (Block block : validBlocks) {
            this.extraConnections.put(block, supplier);
        }
    }

    public static Direction makeContext(BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61376_)) {
            AttachFace attachFace = (AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_);
            return switch (attachFace) {
                default -> throw new IncompatibleClassChangeError();
                case AttachFace.CEILING -> Direction.DOWN;
                case AttachFace.FLOOR -> Direction.UP;
                case AttachFace.WALL -> (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            };
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            return (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            return (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        }
        return null;
    }

    public ConnectionExtra<T> getListener(Block block) {
        return this.extraConnections.get(block);
    }

    public String toString() {
        ResourceLocation id = EGRegistries.PANEL_CONNECTION_REGISTRY.get().getKey((Object)this);
        return id == null ? "unregistered" : id.toString();
    }
}

