/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.registry;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.liukrast.eg.EGConstants;
import net.liukrast.eg.networking.FactoryPanelChangeSizePacket;
import net.liukrast.eg.networking.PanelCacheUpdatePacket;
import net.liukrast.eg.networking.StringPanelUpdatePacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public enum RegisterPackets {
    FACTORY_PANEL_CHANGE_SIZE(FactoryPanelChangeSizePacket.class, FactoryPanelChangeSizePacket::new, NetworkDirection.PLAY_TO_SERVER),
    STRING_PANEL_UPDATE(StringPanelUpdatePacket.class, StringPanelUpdatePacket::new, NetworkDirection.PLAY_TO_SERVER),
    PANEL_CACHE_UPDATE(PanelCacheUpdatePacket.class, PanelCacheUpdatePacket::new, NetworkDirection.PLAY_TO_CLIENT);

    public static final ResourceLocation CHANNEL_NAME;
    public static final int NETWORK_VERSION = 1;
    public static final String NETWORK_VERSION_STR;
    private static SimpleChannel channel;
    private final PacketType<?> packetType;

    private <T extends SimplePacketBase> RegisterPackets(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
        this.packetType = new PacketType<T>(type, factory, direction);
    }

    public static void registerPackets() {
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)CHANNEL_NAME).serverAcceptedVersions(NETWORK_VERSION_STR::equals).clientAcceptedVersions(NETWORK_VERSION_STR::equals).networkProtocolVersion(() -> NETWORK_VERSION_STR).simpleChannel();
        for (RegisterPackets packet : RegisterPackets.values()) {
            packet.packetType.register();
        }
    }

    public static SimpleChannel getChannel() {
        return channel;
    }

    static {
        CHANNEL_NAME = EGConstants.id("main", new Object[0]);
        NETWORK_VERSION_STR = String.valueOf(1);
    }

    private static class PacketType<T extends SimplePacketBase> {
        private static int index = 0;
        private final BiConsumer<T, FriendlyByteBuf> encoder = SimplePacketBase::write;
        private final Function<FriendlyByteBuf, T> decoder;
        private final BiConsumer<T, Supplier<NetworkEvent.Context>> handler;
        private final Class<T> type;
        private final NetworkDirection direction;

        private PacketType(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
            this.decoder = factory;
            this.handler = (packet, contextSupplier) -> {
                NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
                if (packet.handle(context)) {
                    context.setPacketHandled(true);
                }
            };
            this.type = type;
            this.direction = direction;
        }

        private void register() {
            RegisterPackets.getChannel().messageBuilder(this.type, index++, this.direction).encoder(this.encoder).decoder(this.decoder).consumerNetworkThread(this.handler).add();
        }
    }
}

