/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics.board;

import com.mojang.serialization.Codec;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import net.createmod.catnip.gui.ScreenOpener;
import net.liukrast.eg.ExtraGaugesConfig;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnection;
import net.liukrast.eg.api.registry.PanelType;
import net.liukrast.eg.api.util.CacheContainer;
import net.liukrast.eg.api.util.ConnectionExtra;
import net.liukrast.eg.content.logistics.DisplayCollectorBlockEntity;
import net.liukrast.eg.content.logistics.board.StringPanelScreen;
import net.liukrast.eg.registry.EGItems;
import net.liukrast.eg.registry.EGPanelConnections;
import net.liukrast.eg.registry.EGPartialModels;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StringPanelBehaviour
extends AbstractPanelBehaviour
implements CacheContainer<String> {
    @Nullable
    private String value;
    @Nullable
    private String join;
    @Nullable
    private String regex;
    @Nullable
    private String replacement;
    private int intValue = 0;
    private int updated = 0;
    private final Map<BlockPos, String> cache = new HashMap<BlockPos, String>();

    public StringPanelBehaviour(PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super(type, be, slot);
    }

    @Override
    public void addConnections(AbstractPanelBehaviour.PanelConnectionBuilder builder) {
        builder.put((PanelConnection)EGPanelConnections.STRING.get(), () -> this.getDisplayLinkComponent(false).getString());
        builder.put((PanelConnection)EGPanelConnections.INTEGER.get(), () -> this.intValue);
        builder.put((PanelConnection)EGPanelConnections.REDSTONE.get(), () -> Mth.clamp((int)this.intValue, (int)0, (int)15));
    }

    @Override
    public Item getItem() {
        return EGItems.STRING_GAUGE.asItem();
    }

    @Override
    public PartialModel getModel(FactoryPanelBlock.PanelState panelState, FactoryPanelBlock.PanelType panelType) {
        return EGPartialModels.STRING_PANEL;
    }

    @Override
    public Map<BlockPos, String> cacheMap() {
        return this.cache;
    }

    @Override
    public Codec<String> cacheCodec() {
        return Codec.STRING;
    }

    @Override
    public void easyWrite(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.easyWrite(nbt, registries, clientPacket);
        if (this.value != null && !this.value.isEmpty()) {
            nbt.putString("Value", this.value);
        }
        if (this.join != null && !this.join.isEmpty()) {
            nbt.putString("Join", this.join);
        }
        if (this.regex != null && !this.regex.isEmpty()) {
            nbt.putString("Regex", this.regex);
        }
        if (this.replacement != null && !this.replacement.isEmpty()) {
            nbt.putString("Replacement", this.replacement);
        }
    }

    @Override
    public void easyRead(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.easyRead(nbt, registries, clientPacket);
        this.value = nbt.contains("Value") ? nbt.getString("Value") : null;
        this.join = nbt.contains("Join") ? nbt.getString("Join") : null;
        this.regex = nbt.contains("Regex") ? nbt.getString("Regex") : null;
        String string = this.replacement = nbt.contains("Replacement") ? nbt.getString("Replacement") : null;
        if (this.value != null) {
            try {
                this.intValue = Integer.parseInt(this.value);
            }
            catch (NumberFormatException ignored) {
                this.intValue = 0;
            }
        }
    }

    public void tick() {
        super.tick();
        this.updated = 0;
    }

    public void checkForRedstoneInput() {
        if (!this.active || this.updated > (Integer)ExtraGaugesConfig.STRING_MAX_CHAIN.get()) {
            return;
        }
        StringJoiner stringList = new StringJoiner(this.join == null ? "" : this.join);
        this.consumeForLinks(link -> {
            SmartBlockEntity patt0$temp = link.blockEntity;
            if (patt0$temp instanceof DisplayCollectorBlockEntity) {
                DisplayCollectorBlockEntity collector = (DisplayCollectorBlockEntity)patt0$temp;
                stringList.add(collector.getComponent().getString());
            }
        });
        this.consumeForExtra((PanelConnection)EGPanelConnections.STRING.get(), (pos, v) -> {
            this.cache.put((BlockPos)pos, (String)v);
            stringList.add((CharSequence)v);
        });
        this.consumeForPanels((PanelConnection)EGPanelConnections.STRING.get(), stringList::add);
        String result = stringList.toString();
        int maxLength = (Integer)ExtraGaugesConfig.STRING_MAX_LENGTH.get();
        if (result.length() > maxLength) {
            result = result.substring(0, maxLength);
        }
        if (this.regex != null && !this.regex.isEmpty()) {
            try {
                Pattern pattern = Pattern.compile(this.regex);
                result = pattern.matcher(result).replaceAll(this.replacement == null ? "" : this.replacement);
            }
            catch (PatternSyntaxException e) {
                result = "RegexError";
            }
        }
        this.sendCache(this);
        if (result.equals(this.value)) {
            return;
        }
        this.value = result;
        try {
            this.intValue = Math.round(Float.parseFloat(this.value));
        }
        catch (NumberFormatException ignored) {
            this.intValue = 0;
        }
        this.blockEntity.notifyUpdate();
        ++this.updated;
        for (FactoryPanelPosition panelPos : this.targeting) {
            if (!this.getWorld().isLoaded(panelPos.pos())) {
                return;
            }
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelPosition)panelPos);
            if (behaviour == null) continue;
            behaviour.checkForRedstoneInput();
        }
        this.notifyRedstoneOutputs();
    }

    public void setFilter(String join, String regex, String replace) {
        this.join = join;
        this.regex = regex;
        this.replacement = replace;
        this.blockEntity.notifyUpdate();
        this.checkForRedstoneInput();
    }

    @Nullable
    public String getJoin() {
        return this.join;
    }

    @Nullable
    public String getRegex() {
        return this.regex;
    }

    @Nullable
    public String getReplacement() {
        return this.replacement;
    }

    @Override
    public int calculatePath(FactoryPanelBehaviour other, int original) {
        return EGPanelConnections.getConnectionValue(other, EGPanelConnections.STRING).map(str -> 0xFFFFFF).orElse(super.calculatePath(other, original));
    }

    @Override
    public int calculateExtraPath(BlockPos pos) {
        Level level = this.getWorld();
        BlockState state = level.getBlockState(pos);
        BlockEntity be = level.getBlockEntity(pos);
        ConnectionExtra listener = ((PanelConnection)EGPanelConnections.STRING.get()).getListener(state.getBlock());
        if (listener != null) {
            Optional opt = listener.invalidate(level, state, pos, be);
            String cache = this.cache.get(pos);
            if (opt.isPresent()) {
                return (Boolean)ExtraGaugesConfig.PANEL_CACHING.get() == false || cache != null && cache.equals(opt.get()) ? 0xFFFFFF : 16766273;
            }
        }
        return super.calculateExtraPath(pos);
    }

    @Override
    public MutableComponent getDisplayLinkComponent(boolean shortenNumbers) {
        return this.value == null ? Component.empty() : Component.literal((String)this.value);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void displayScreen(Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new StringPanelScreen(this));
        }
    }
}

