/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics.board;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.redstone.link.RedstoneLinkBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.createmod.catnip.gui.ScreenOpener;
import net.liukrast.eg.ExtraGaugesConfig;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnection;
import net.liukrast.eg.api.registry.PanelType;
import net.liukrast.eg.api.util.CacheContainer;
import net.liukrast.eg.api.util.ConnectionExtra;
import net.liukrast.eg.content.logistics.board.ComparatorMode;
import net.liukrast.eg.content.logistics.board.ComparatorPanelScreen;
import net.liukrast.eg.content.logistics.board.NumericalScrollPanelBehaviour;
import net.liukrast.eg.registry.EGItems;
import net.liukrast.eg.registry.EGPanelConnections;
import net.liukrast.eg.registry.EGPartialModels;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ComparatorPanelBehaviour
extends NumericalScrollPanelBehaviour
implements CacheContainer<Integer> {
    int comparatorMode = 0;
    private int updated = 0;
    private final Map<BlockPos, Integer> cache = new HashMap<BlockPos, Integer>();

    public ComparatorPanelBehaviour(PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super((Component)Component.m_237115_((String)"create.logistics.comparator_value"), type, be, slot);
        this.between(-256, 256);
    }

    @Override
    public Map<BlockPos, Integer> cacheMap() {
        return this.cache;
    }

    @Override
    public Codec<Integer> cacheCodec() {
        return Codec.INT;
    }

    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        ImmutableList rows = ImmutableList.of((Object)Component.m_237113_((String)"Positive").m_130940_(ChatFormatting.BOLD), (Object)Component.m_237113_((String)"Negative").m_130940_(ChatFormatting.BOLD));
        ValueSettingsFormatter formatter = new ValueSettingsFormatter(this::formatSettings);
        return new ValueSettingsBoard(this.label, 256, 32, (List)rows, formatter);
    }

    @Override
    public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlHeld) {
        if (valueSetting.row() == 2) {
            this.comparatorMode = Mth.m_14045_((int)valueSetting.value(), (int)0, (int)(ComparatorMode.values().length - 1));
            this.checkForRedstoneInput();
        } else {
            int value = valueSetting.value();
            if (!valueSetting.equals((Object)this.getValueSettings())) {
                this.playFeedbackSound((BlockEntityBehaviour)this);
            }
            this.setValue(valueSetting.row() == 0 ? value : -value);
        }
    }

    @Override
    public void addConnections(AbstractPanelBehaviour.PanelConnectionBuilder builder) {
        builder.put(EGPanelConnections.REDSTONE, () -> !this.redstonePowered ? 15 : 0);
        builder.put((PanelConnection)EGPanelConnections.STRING.get(), () -> this.getDisplayLinkComponent(false).getString());
    }

    @Override
    public void easyWrite(CompoundTag nbt, boolean clientPacket) {
        super.easyWrite(nbt, clientPacket);
        nbt.m_128405_("ComparatorMode", this.comparatorMode);
    }

    @Override
    public void easyRead(CompoundTag nbt, boolean clientPacket) {
        super.easyRead(nbt, clientPacket);
        this.comparatorMode = nbt.m_128451_("ComparatorMode");
    }

    @Override
    public Item getItem() {
        return (Item)EGItems.COMPARATOR_GAUGE.get();
    }

    @Override
    public PartialModel getModel(FactoryPanelBlock.PanelState panelState, FactoryPanelBlock.PanelType panelType) {
        return EGPartialModels.COMPARATOR_PANEL;
    }

    public void tick() {
        super.tick();
        this.updated = 0;
    }

    @Override
    public boolean shouldRenderBulb(boolean original) {
        return true;
    }

    public void checkForRedstoneInput() {
        if (!this.active || this.updated > (Integer)ExtraGaugesConfig.COMPARATOR_MAX_CHAIN.get()) {
            return;
        }
        AtomicInteger result = new AtomicInteger();
        this.consumeForLinks(link -> {
            SmartBlockEntity patt4947$temp;
            if (link.shouldPanelBePowered() && (patt4947$temp = link.blockEntity) instanceof RedstoneLinkBlockEntity) {
                RedstoneLinkBlockEntity redstoneLink = (RedstoneLinkBlockEntity)patt4947$temp;
                result.addAndGet(redstoneLink.getReceivedSignal());
            } else {
                result.addAndGet(link.shouldPanelBePowered() ? 1 : 0);
            }
        });
        this.consumeForPanels((PanelConnection)EGPanelConnections.INTEGER.get(), result::addAndGet);
        this.consumeForExtra((PanelConnection)EGPanelConnections.INTEGER.get(), (pos, v) -> {
            result.addAndGet((int)v);
            this.cache.put((BlockPos)pos, (Integer)v);
        });
        this.sendCache(this);
        boolean shouldPower = ((ComparatorMode[])ComparatorMode.class.getEnumConstants())[this.comparatorMode].test(result.get(), this.value);
        if (shouldPower != this.redstonePowered) {
            return;
        }
        this.redstonePowered = !shouldPower;
        this.blockEntity.notifyUpdate();
        ++this.updated;
        for (FactoryPanelPosition panelPos : this.targeting) {
            if (!this.getWorld().m_46749_(panelPos.pos())) {
                return;
            }
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelPosition)panelPos);
            if (behaviour == null) continue;
            behaviour.checkForRedstoneInput();
        }
        this.notifyRedstoneOutputs();
    }

    @Override
    public MutableComponent getDisplayLinkComponent(boolean shortened) {
        boolean active = this.getConnectionValue(EGPanelConnections.REDSTONE).orElse(0) > 0;
        Object t = "\u2714";
        Object f = "\u2716";
        if (!shortened) {
            t = (String)t + " True";
            f = (String)f + " False";
        }
        return Component.m_237113_((String)(active ? t : f));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void displayScreen(Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new ComparatorPanelScreen(this));
        }
    }

    @Override
    public int calculatePath(FactoryPanelBehaviour other, int original) {
        if (EGPanelConnections.getConnectionValue(other, EGPanelConnections.INTEGER).isPresent()) {
            return 25750;
        }
        return super.calculatePath(other, original);
    }

    @Override
    public int calculateExtraPath(BlockPos pos) {
        ConnectionExtra listener;
        Level level = this.getWorld();
        BlockState state = level.m_8055_(pos);
        BlockEntity be = level.m_7702_(pos);
        ConnectionExtra intListener = ((PanelConnection)EGPanelConnections.INTEGER.get()).getListener(state.m_60734_());
        if (intListener != null) {
            Optional opt = intListener.invalidate(level, state, pos, be);
            Integer cache = this.cache.get(pos);
            if (opt.isPresent()) {
                return (Boolean)ExtraGaugesConfig.PANEL_CACHING.get() == false || ((Integer)opt.get()).equals(cache) ? 25750 : 16766273;
            }
        }
        if ((listener = ((PanelConnection)EGPanelConnections.REDSTONE.get()).getListener(state.m_60734_())) == null) {
            return super.calculateExtraPath(pos);
        }
        return listener.invalidate(level, state, pos, be).map(v -> {
            boolean k = v == 0;
            Integer cache = this.cache.get(pos);
            if (((Boolean)ExtraGaugesConfig.PANEL_CACHING.get()).booleanValue() && cache != null && k == cache > 0) {
                return 16766273;
            }
            return k ? 5767425 : 0xEF0000;
        }).orElse(super.calculateExtraPath(pos));
    }
}

