/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.ponder.scenes.highLogistics;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.function.Consumer;
import net.createmod.ponder.api.element.TextElementBuilder;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.liukrast.eg.api.util.IFPExtra;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.SignBlockEntity;

public class GaugeHelper {
    public static CreateSceneBuilder simpleInit(SceneBuilder builder, SceneBuildingUtil util, String id) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title(id, "");
        scene.configureBasePlate(0, 0, 7);
        scene.scaleSceneView(0.825f);
        scene.setSceneOffsetY(-2.0f);
        scene.world().showIndependentSection(util.select().fromTo(7, 0, 0, 0, 0, 7), Direction.UP);
        scene.idle(10);
        return scene;
    }

    public static void displayText(SceneBuilder builder, BlockPos pos, int time, boolean keyframe) {
        TextElementBuilder overlay = builder.overlay().showText(time).text("").placeNearTarget().pointAt(pos.m_252807_().m_82520_(-0.25, 0.25, 0.0));
        if (keyframe) {
            overlay.attachKeyFrame();
        }
        builder.idle(time + 20);
    }

    public static void activateRedstone(SceneBuilder builder, BlockPos pos) {
        builder.world().toggleRedstonePower(builder.getScene().getSceneBuildingUtil().select().position(pos));
        builder.effects().indicateRedstone(pos);
    }

    public static void setSignText(SceneBuilder builder, BlockPos pos, int line, Component text) {
        builder.world().modifyBlockEntity(pos, SignBlockEntity.class, be -> be.m_276956_(be.m_277157_(true).m_276913_(line, text), true));
    }

    public static void setNixieTubeText(SceneBuilder builder, BlockPos start, Component text, int length, Direction direction) {
        int i = 0;
        while (i < length) {
            int index = i++;
            builder.world().modifyBlockEntityNBT(builder.getScene().getSceneBuildingUtil().select().position(start.m_5484_(direction, index)), NixieTubeBlockEntity.class, nbt -> {
                String asRaw = Component.Serializer.m_130703_((Component)text);
                nbt.m_128359_("RawCustomText", asRaw);
                nbt.m_128359_("CustomText", asRaw);
                nbt.m_128405_("CustomTextIndex", index);
            });
        }
    }

    public static void setPanelItem(SceneBuilder builder, FactoryPanelPosition gauge, ItemStack item) {
        GaugeHelper.withGaugeDo(builder, gauge, pb -> pb.setFilter(item));
    }

    public static void setPanelPowered(SceneBuilder builder, FactoryPanelPosition gauge, boolean power) {
        GaugeHelper.withGaugeDo(builder, gauge, pb -> {
            pb.redstonePowered = power;
        });
    }

    public static void setPanelVisible(SceneBuilder builder, FactoryPanelPosition gauge, boolean visible) {
        GaugeHelper.withGaugeDo(builder, gauge, pb -> {
            pb.active = visible;
        });
    }

    public static void setPanelNotSatisfied(SceneBuilder builder, FactoryPanelPosition gauge) {
        GaugeHelper.withGaugeDo(builder, gauge, pb -> {
            pb.count = 2;
        });
    }

    public static void setPanelCrafting(SceneBuilder builder, SceneBuildingUtil util, FactoryPanelPosition gauge) {
        builder.world().modifyBlockEntityNBT(util.select().position(gauge.pos()), FactoryPanelBlockEntity.class, tag -> {
            CompoundTag panelTag = tag.m_128469_(CreateLang.asId((String)gauge.slot().name()));
            panelTag.m_128405_("LastPromised", 1);
        });
    }

    public static void flash(SceneBuilder builder, FactoryPanelPosition gauge) {
        GaugeHelper.withGaugeDo(builder, gauge, pb -> pb.bulb.setValue(1.0));
    }

    public static void setPanelSatisfied(SceneBuilder builder, FactoryPanelPosition gauge) {
        GaugeHelper.withGaugeDo(builder, gauge, pb -> {
            pb.count = 1;
        });
    }

    public static void setPanelPassive(SceneBuilder builder, FactoryPanelPosition gauge) {
        GaugeHelper.withGaugeDo(builder, gauge, pb -> {
            pb.count = 0;
        });
    }

    public static void setConnectionAmount(SceneBuilder builder, FactoryPanelPosition from, FactoryPanelPosition to, int amount) {
        GaugeHelper.withGaugeDo(builder, from, pb -> {
            ((FactoryPanelConnection)pb.targetedBy.get((Object)to)).amount = amount;
        });
    }

    public static void removePanelConnections(SceneBuilder builder, FactoryPanelPosition gauge) {
        GaugeHelper.withGaugeDo(builder, gauge, FactoryPanelBehaviour::disconnectAll);
    }

    public static void setArrowMode(SceneBuilder builder, FactoryPanelPosition gauge, FactoryPanelPosition from, int mode) {
        GaugeHelper.withGaugeDo(builder, gauge, pb -> {
            FactoryPanelConnection connection = (FactoryPanelConnection)pb.targetedBy.get(new FactoryPanelPosition(from.pos(), from.slot()));
            if (connection == null && (connection = (FactoryPanelConnection)pb.targetedByLinks.get(from.pos())) == null && (connection = ((IFPExtra)pb).extra_gauges$getExtra().get(from.pos())) == null) {
                return;
            }
            connection.arrowBendMode = mode;
        });
    }

    public static void addPanelConnection(SceneBuilder builder, FactoryPanelPosition gauge, FactoryPanelPosition from) {
        GaugeHelper.withGaugeDo(builder, gauge, pb -> pb.addConnection(new FactoryPanelPosition(from.pos(), from.slot())));
    }

    public static void withGaugeDo(SceneBuilder builder, FactoryPanelPosition gauge, Consumer<FactoryPanelBehaviour> call) {
        builder.world().modifyBlockEntity(gauge.pos(), FactoryPanelBlockEntity.class, be -> call.accept((FactoryPanelBehaviour)be.panels.get(gauge.slot())));
    }
}

