/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butchery.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BatheadBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public BatheadBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)BatheadBlock.box((double)7.25, (double)-0.01244, (double)7.18744, (double)8.75, (double)1.48756, (double)8.68744), (VoxelShape[])new VoxelShape[]{BatheadBlock.box((double)7.0, (double)1.23756, (double)8.18744, (double)7.75, (double)2.23756, (double)8.43744), BatheadBlock.box((double)8.25, (double)1.23756, (double)8.18744, (double)9.0, (double)2.23756, (double)8.43744)});
            case Direction.NORTH -> Shapes.or((VoxelShape)BatheadBlock.box((double)7.25, (double)-0.01244, (double)7.31256, (double)8.75, (double)1.48756, (double)8.81256), (VoxelShape[])new VoxelShape[]{BatheadBlock.box((double)8.25, (double)1.23756, (double)7.56256, (double)9.0, (double)2.23756, (double)7.81256), BatheadBlock.box((double)7.0, (double)1.23756, (double)7.56256, (double)7.75, (double)2.23756, (double)7.81256)});
            case Direction.EAST -> Shapes.or((VoxelShape)BatheadBlock.box((double)7.18744, (double)-0.01244, (double)7.25, (double)8.68744, (double)1.48756, (double)8.75), (VoxelShape[])new VoxelShape[]{BatheadBlock.box((double)8.18744, (double)1.23756, (double)8.25, (double)8.43744, (double)2.23756, (double)9.0), BatheadBlock.box((double)8.18744, (double)1.23756, (double)7.0, (double)8.43744, (double)2.23756, (double)7.75)});
            case Direction.WEST -> Shapes.or((VoxelShape)BatheadBlock.box((double)7.31256, (double)-0.01244, (double)7.25, (double)8.81256, (double)1.48756, (double)8.75), (VoxelShape[])new VoxelShape[]{BatheadBlock.box((double)7.56256, (double)1.23756, (double)7.0, (double)7.81256, (double)2.23756, (double)7.75), BatheadBlock.box((double)7.56256, (double)1.23756, (double)8.25, (double)7.81256, (double)2.23756, (double)9.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }
}

