/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butchery.block;

import net.mcreator.butchery.procedures.BloodsplatterrightclickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BloodsplatterBlock
extends Block {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)9);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<AttachFace> FACE = FaceAttachedHorizontalDirectionalBlock.FACE;

    public BloodsplatterBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.SLIME_BLOCK).strength(1.0f, 10.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 2) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 3) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 4) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 5) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 6) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 7) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 8) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 9) {
                    return 0;
                }
                return 0;
            }
        }.getLightLevel()).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).dynamicShape());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(FACE, (Comparable)AttachFace.WALL));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield BloodsplatterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.2, (double)16.0);
                    }
                    case WALL: {
                        yield BloodsplatterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.2);
                    }
                    case CEILING: 
                }
                yield BloodsplatterBlock.box((double)0.0, (double)15.8, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            }
            case Direction.NORTH -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield BloodsplatterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.2, (double)16.0);
                    }
                    case WALL: {
                        yield BloodsplatterBlock.box((double)0.0, (double)0.0, (double)15.8, (double)16.0, (double)16.0, (double)16.0);
                    }
                    case CEILING: 
                }
                yield BloodsplatterBlock.box((double)0.0, (double)15.8, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            }
            case Direction.EAST -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield BloodsplatterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.2, (double)16.0);
                    }
                    case WALL: {
                        yield BloodsplatterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)0.2, (double)16.0, (double)16.0);
                    }
                    case CEILING: 
                }
                yield BloodsplatterBlock.box((double)0.0, (double)15.8, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            }
            case Direction.WEST -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield BloodsplatterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.2, (double)16.0);
                    }
                    case WALL: {
                        yield BloodsplatterBlock.box((double)15.8, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
                    }
                    case CEILING: 
                }
                yield BloodsplatterBlock.box((double)0.0, (double)15.8, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            }
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, FACE, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACE, (Comparable)this.faceForDirection(context.getNearestLookingDirection()))).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    private AttachFace faceForDirection(Direction direction) {
        if (direction.getAxis() == Direction.Axis.Y) {
            return direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR;
        }
        return AttachFace.WALL;
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        BloodsplatterrightclickProcedure.execute((LevelAccessor)world, x, y, z, blockstate, (Entity)entity);
        return InteractionResult.SUCCESS;
    }
}

