/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butchery.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PandaheadBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public PandaheadBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)PandaheadBlock.box((double)1.5221, (double)0.04591, (double)2.56309, (double)14.5221, (double)10.04591, (double)11.56309), (VoxelShape[])new VoxelShape[]{PandaheadBlock.box((double)4.5221, (double)0.04591, (double)11.56309, (double)11.5221, (double)5.04591, (double)13.56309), PandaheadBlock.box((double)-0.4779, (double)8.09311, (double)7.56309, (double)4.5221, (double)12.09311, (double)8.56309), PandaheadBlock.box((double)11.5221, (double)8.09311, (double)7.56309, (double)16.5221, (double)12.09311, (double)8.56309)});
            case Direction.NORTH -> Shapes.or((VoxelShape)PandaheadBlock.box((double)1.4779, (double)0.04591, (double)4.43691, (double)14.4779, (double)10.04591, (double)13.43691), (VoxelShape[])new VoxelShape[]{PandaheadBlock.box((double)4.4779, (double)0.04591, (double)2.43691, (double)11.4779, (double)5.04591, (double)4.43691), PandaheadBlock.box((double)11.4779, (double)8.09311, (double)7.43691, (double)16.4779, (double)12.09311, (double)8.43691), PandaheadBlock.box((double)-0.5221, (double)8.09311, (double)7.43691, (double)4.4779, (double)12.09311, (double)8.43691)});
            case Direction.EAST -> Shapes.or((VoxelShape)PandaheadBlock.box((double)2.56309, (double)0.04591, (double)1.4779, (double)11.56309, (double)10.04591, (double)14.4779), (VoxelShape[])new VoxelShape[]{PandaheadBlock.box((double)11.56309, (double)0.04591, (double)4.4779, (double)13.56309, (double)5.04591, (double)11.4779), PandaheadBlock.box((double)7.56309, (double)8.09311, (double)11.4779, (double)8.56309, (double)12.09311, (double)16.4779), PandaheadBlock.box((double)7.56309, (double)8.09311, (double)-0.5221, (double)8.56309, (double)12.09311, (double)4.4779)});
            case Direction.WEST -> Shapes.or((VoxelShape)PandaheadBlock.box((double)4.43691, (double)0.04591, (double)1.5221, (double)13.43691, (double)10.04591, (double)14.5221), (VoxelShape[])new VoxelShape[]{PandaheadBlock.box((double)2.43691, (double)0.04591, (double)4.5221, (double)4.43691, (double)5.04591, (double)11.5221), PandaheadBlock.box((double)7.43691, (double)8.09311, (double)-0.4779, (double)8.43691, (double)12.09311, (double)4.5221), PandaheadBlock.box((double)7.43691, (double)8.09311, (double)11.5221, (double)8.43691, (double)12.09311, (double)16.5221)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }
}

