/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butchery.block;

import net.mcreator.butchery.block.entity.WardencarcassBlockEntity;
import net.mcreator.butchery.procedures.WardencutupProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WardencarcassBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public WardencarcassBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.SCULK_SENSOR).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)WardencarcassBlock.box((double)10.1, (double)-0.03327, (double)2.99477, (double)16.1, (double)5.96673, (double)15.99477), (VoxelShape[])new VoxelShape[]{WardencarcassBlock.box((double)0.1, (double)7.21942, (double)1.54797, (double)16.1, (double)19.21942, (double)10.54797), WardencarcassBlock.box((double)0.1, (double)19.21942, (double)2.54797, (double)16.1, (double)26.21942, (double)11.54797), WardencarcassBlock.box((double)-0.1, (double)-0.03327, (double)2.99477, (double)5.9, (double)5.96673, (double)15.99477)});
            case Direction.NORTH -> Shapes.or((VoxelShape)WardencarcassBlock.box((double)-0.1, (double)-0.03327, (double)0.00523, (double)5.9, (double)5.96673, (double)13.00523), (VoxelShape[])new VoxelShape[]{WardencarcassBlock.box((double)-0.1, (double)7.21942, (double)5.45203, (double)15.9, (double)19.21942, (double)14.45203), WardencarcassBlock.box((double)-0.1, (double)19.21942, (double)4.45203, (double)15.9, (double)26.21942, (double)13.45203), WardencarcassBlock.box((double)10.1, (double)-0.03327, (double)0.00523, (double)16.1, (double)5.96673, (double)13.00523)});
            case Direction.EAST -> Shapes.or((VoxelShape)WardencarcassBlock.box((double)2.99477, (double)-0.03327, (double)-0.1, (double)15.99477, (double)5.96673, (double)5.9), (VoxelShape[])new VoxelShape[]{WardencarcassBlock.box((double)1.54797, (double)7.21942, (double)-0.1, (double)10.54797, (double)19.21942, (double)15.9), WardencarcassBlock.box((double)2.54797, (double)19.21942, (double)-0.1, (double)11.54797, (double)26.21942, (double)15.9), WardencarcassBlock.box((double)2.99477, (double)-0.03327, (double)10.1, (double)15.99477, (double)5.96673, (double)16.1)});
            case Direction.WEST -> Shapes.or((VoxelShape)WardencarcassBlock.box((double)0.00523, (double)-0.03327, (double)10.1, (double)13.00523, (double)5.96673, (double)16.1), (VoxelShape[])new VoxelShape[]{WardencarcassBlock.box((double)5.45203, (double)7.21942, (double)0.1, (double)14.45203, (double)19.21942, (double)16.1), WardencarcassBlock.box((double)4.45203, (double)19.21942, (double)0.1, (double)13.45203, (double)26.21942, (double)16.1), WardencarcassBlock.box((double)0.00523, (double)-0.03327, (double)-0.1, (double)13.00523, (double)5.96673, (double)5.9)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        WardencutupProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WardencarcassBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof WardencarcassBlockEntity) {
                WardencarcassBlockEntity be = (WardencarcassBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof WardencarcassBlockEntity) {
            WardencarcassBlockEntity be = (WardencarcassBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

