/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.butchery.block.CashregisterblockBlock;
import net.mcreator.butchery.block.entity.CashregisterblockBlockEntity;
import net.mcreator.butchery.client.model.Modelcash_register;
import net.mcreator.butchery.client.model.animations.registercloseAnimation;
import net.mcreator.butchery.client.model.animations.registeropenAnimation;
import net.mcreator.butchery.init.ButcheryModBlockEntities;
import net.mcreator.butchery.procedures.RegisteCloseConditionProcedure;
import net.mcreator.butchery.procedures.RegisterOpenConditionProcedure;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class CashregisterblockRenderer
implements BlockEntityRenderer<CashregisterblockBlockEntity> {
    private final CustomHierarchicalModel model;
    private final ResourceLocation texture;
    private final LivingEntityRenderState renderState;

    CashregisterblockRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new CustomHierarchicalModel(context.bakeLayer(Modelcash_register.LAYER_LOCATION));
        this.texture = ResourceLocation.parse((String)"butchery:textures/block/cash_register.png");
        this.renderState = new LivingEntityRenderState();
    }

    private void updateRenderState(CashregisterblockBlockEntity blockEntity, float partialTick) {
        int tickCount = (int)blockEntity.getLevel().getGameTime();
        this.renderState.ageInTicks = (float)tickCount + partialTick;
        blockEntity.animationState0.animateWhen(RegisteCloseConditionProcedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
        blockEntity.animationState1.animateWhen(RegisterOpenConditionProcedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
    }

    public void render(CashregisterblockBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource renderer, int light, int overlayLight) {
        this.updateRenderState(blockEntity, partialTick);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, 0.5);
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue(CashregisterblockBlock.FACING);
        switch (facing) {
            case NORTH: {
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer builder = renderer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture));
        this.model.setupBlockEntityAnim(blockEntity, this.renderState);
        this.model.renderToBuffer(poseStack, builder, light, overlayLight);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ButcheryModBlockEntities.CASH_REGISTER_BLOCK.get(), CashregisterblockRenderer::new);
    }

    private static final class CustomHierarchicalModel
    extends Modelcash_register {
        public CustomHierarchicalModel(ModelPart root) {
            super(root);
        }

        public void setupBlockEntityAnim(CashregisterblockBlockEntity blockEntity, LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(blockEntity.animationState0, registercloseAnimation.close, state.ageInTicks, 1.0f);
            this.animate(blockEntity.animationState1, registeropenAnimation.open, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }

        public ModelPart getRoot() {
            return this.root;
        }
    }
}

