/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.butchery.block.WardencarcassBlock;
import net.mcreator.butchery.block.entity.WardencarcassBlockEntity;
import net.mcreator.butchery.client.model.Modelwarden_carcass;
import net.mcreator.butchery.client.model.animations.warden_armlessAnimation;
import net.mcreator.butchery.client.model.animations.warden_bodylessAnimation;
import net.mcreator.butchery.client.model.animations.warden_headlessAnimation;
import net.mcreator.butchery.client.model.animations.warden_riblessAnimation;
import net.mcreator.butchery.init.ButcheryModBlockEntities;
import net.mcreator.butchery.procedures.Wardenanimationcondition1Procedure;
import net.mcreator.butchery.procedures.Wardenanimationcondition2Procedure;
import net.mcreator.butchery.procedures.Wardenanimationcondition3Procedure;
import net.mcreator.butchery.procedures.Wardenanimationcondition4Procedure;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class WardencarcassRenderer
implements BlockEntityRenderer<WardencarcassBlockEntity> {
    private final CustomHierarchicalModel model;
    private final ResourceLocation texture;
    private final LivingEntityRenderState renderState;

    WardencarcassRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new CustomHierarchicalModel(context.bakeLayer(Modelwarden_carcass.LAYER_LOCATION));
        this.texture = ResourceLocation.parse((String)"butchery:textures/block/warden.png");
        this.renderState = new LivingEntityRenderState();
    }

    private void updateRenderState(WardencarcassBlockEntity blockEntity, float partialTick) {
        int tickCount = (int)blockEntity.getLevel().getGameTime();
        this.renderState.ageInTicks = (float)tickCount + partialTick;
        blockEntity.animationState0.animateWhen(Wardenanimationcondition1Procedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
        blockEntity.animationState1.animateWhen(Wardenanimationcondition2Procedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
        blockEntity.animationState2.animateWhen(Wardenanimationcondition3Procedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
        blockEntity.animationState3.animateWhen(Wardenanimationcondition4Procedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
    }

    public void render(WardencarcassBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource renderer, int light, int overlayLight) {
        this.updateRenderState(blockEntity, partialTick);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, 0.5);
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue(WardencarcassBlock.FACING);
        switch (facing) {
            case NORTH: {
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer builder = renderer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture));
        this.model.setupBlockEntityAnim(blockEntity, this.renderState);
        this.model.renderToBuffer(poseStack, builder, light, overlayLight);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ButcheryModBlockEntities.WARDEN_CARCASS.get(), WardencarcassRenderer::new);
    }

    private static final class CustomHierarchicalModel
    extends Modelwarden_carcass {
        public CustomHierarchicalModel(ModelPart root) {
            super(root);
        }

        public void setupBlockEntityAnim(WardencarcassBlockEntity blockEntity, LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(blockEntity.animationState0, warden_headlessAnimation.headless, state.ageInTicks, 1.0f);
            this.animate(blockEntity.animationState1, warden_armlessAnimation.armless, state.ageInTicks, 1.0f);
            this.animate(blockEntity.animationState2, warden_riblessAnimation.ribless, state.ageInTicks, 1.0f);
            this.animate(blockEntity.animationState3, warden_bodylessAnimation.bodyless, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }

        public ModelPart getRoot() {
            return this.root;
        }
    }
}

